(ns com.adgoji.displayvideo-api.advertisers.assets
  (:require
   [com.adgoji.assets.interface :as assets]
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec])
  (:import
   (com.google.api.services.displayvideo.v2 DisplayVideo)))

(defn upload
  "Returns the map which represents newly uploaded asset if successful.

  The asset file size should be no more than 10 MB for images, 200 MB
  for ZIP files, and 1 GB for videos."
  [^DisplayVideo client advertiser-id asset]
  (assets/upload client advertiser-id asset))

(s/fdef upload
  :args (s/cat :client ::spec/client
               :advertiser-id ::spec/advertiser-id
               :asset ::spec/create-asset-request)
  :ret ::spec/create-asset-response)
