(ns com.adgoji.displayvideo-api.advertisers.insertion-orders.assigned-targeting-options
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.insertion-orders-assigned-targeting-options.interface
    :as assigned-targeting-options]
   [com.adgoji.spec.interface :as spec])
  (:import
   (com.google.api.services.displayvideo.v2 DisplayVideo)))

(defn create
  [^DisplayVideo client advertiser-id insertion-order-id targeting-type assigned-targeting-option]
  (assigned-targeting-options/create client
                                     advertiser-id
                                     insertion-order-id
                                     targeting-type
                                     assigned-targeting-option))

(s/fdef create
  :args (s/cat :client ::spec/displayvideo-client
               :advertiser-id ::spec/advertiser-id
               :insertion-order-id ::spec/insertion-order-id
               :targeting-type ::spec/targeting-type
               :assigned-targeting-option ::spec/assigned-targeting-option)
  :ret ::spec/assigned-targeting-option)

(defn delete
  "Delete an assigned-targeting-option by `advertiser-id` and
  `assigned-targeting-option-id`."
  [^DisplayVideo client advertiser-id insertion-order-id targeting-type assigned-targeting-option-id]
  (assigned-targeting-options/delete client
                                     advertiser-id
                                     insertion-order-id
                                     targeting-type
                                     assigned-targeting-option-id))

(s/fdef delete
  :args (s/cat :client ::spec/displayvideo-client
               :advertiser-id ::spec/advertiser-id
               :insertion-order-id ::spec/insertion-order-id
               :targeting-type ::spec/targeting-type
               :assigned-targeting-option-id ::spec/assigned-targeting-option-id)
  :ret (s/and map? empty?))

(defn get-by-id
  "Returns a single assigned-targeting-option by `assigned-targeting-option-id`."
  [^DisplayVideo client advertiser-id insertion-order-id targeting-type assigned-targeting-option-id]
  (assigned-targeting-options/get-by-id client
                                        advertiser-id
                                        insertion-order-id
                                        targeting-type
                                        assigned-targeting-option-id))

(s/fdef get-by-id
  :args (s/cat :client ::spec/displayvideo-client
               :advertiser-id ::spec/advertiser-id
               :insertion-order-id ::spec/insertion-order-id
               :targeting-type ::spec/targeting-type
               :assigned-targeting-option-id ::spec/assigned-targeting-option-id)
  :ret ::spec/assigned-targeting-option)

(defn get-list
  "Returns a list of all assigned targeting options of an insertion order"
  [^DisplayVideo client advertiser-id insertion-order-id targeting-type opts]
  (assigned-targeting-options/get-list client
                                       advertiser-id
                                       insertion-order-id
                                       targeting-type opts))

(s/fdef get-list
  :args (s/cat :client ::spec/displayvideo-client
               :advertiser-id ::spec/advertiser-id
               :insertion-order-id ::spec/insertion-order-id
               :targeting-type ::spec/targeting-type
               :opts (s/keys :opt-un [::spec/order-by
                                      ::spec/filter-expr
                                      ::spec/limit]))
  :ret ::spec/assigned-targeting-options)
