(ns com.adgoji.line-items-assigned-targeting-options.interface
  (:require
   [com.adgoji.line-items-assigned-targeting-options.core
    :as line-items-assigned-targeting-options.core])
  (:import
   (com.google.api.services.displayvideo.v2 DisplayVideo)))

(defn create
  [^DisplayVideo client advertiser-id line-item-id targeting-type assigned-targeting-option]
  (line-items-assigned-targeting-options.core/create client
                                                     advertiser-id
                                                     line-item-id
                                                     targeting-type
                                                     assigned-targeting-option))

(defn delete
  [^DisplayVideo client advertiser-id line-item-id targeting-type assigned-targeting-option-id]
  (line-items-assigned-targeting-options.core/delete client
                                                     advertiser-id
                                                     line-item-id
                                                     targeting-type
                                                     assigned-targeting-option-id))

(defn get-by-id
  [^DisplayVideo client advertiser-id line-item-id targeting-type assigned-targeting-option-id]
  (line-items-assigned-targeting-options.core/get-by-id client
                                                        advertiser-id
                                                        line-item-id
                                                        targeting-type
                                                        assigned-targeting-option-id))

(defn get-list
  [^DisplayVideo client advertiser-id line-item-id targeting-type opts]
  (line-items-assigned-targeting-options.core/get-list client
                                                       advertiser-id
                                                       line-item-id
                                                       targeting-type opts))