(ns com.adgoji.sdk-client-utils.core
  (:require
   [camel-snake-kebab.core :as csk]
   [clojure.core.memoize :as m]
   [clojure.java.data :as j]
   [camel-snake-kebab.extras :as cske])
  (:import
   (com.google.api.client.googleapis.services AbstractGoogleClientRequest)))

(def ^:private memoized->kebab-case-keyword
  (m/fifo (fn [input]
            (csk/->kebab-case-keyword input :separator #"(?<![A-Z])(?=[A-Z])"))
          {}
          :fifo/threshold 512))

(defn execute
  [^AbstractGoogleClientRequest request]
  (.execute request))

(defn execute-and-convert
  [^AbstractGoogleClientRequest request]
  (let [response (-> request
                     (execute)
                     (j/from-java-deep {}))]
    (cske/transform-keys memoized->kebab-case-keyword response)))

(defn execute-and-convert-paginated
  [fetch-page-fn vkey limit]
  (let [xform (if limit
                (comp cat (take limit))
                cat)]
    (->> (iteration fetch-page-fn
                    :kf :next-page-token
                    :vf vkey
                    :initk nil)
         (into [] xform))))
