(ns com.adgoji.spec.interface
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.displayvideo :as displayvideo]
   [com.adgoji.spec.utils :as utils]
   [com.adgoji.spec.displayvideo.advertiser :as advertiser]
   [com.adgoji.spec.displayvideo.creative :as creative]
   [com.adgoji.spec.displayvideo.campaign :as campaign]
   [com.adgoji.spec.displayvideo.line-item :as line-item]
   [com.adgoji.spec.displayvideo.insertion-order :as insertion-order]
   [com.adgoji.spec.displayvideo.assigned-targeting-option :as assigned-targeting-option]))

;;; Utils
(defn check
  [v spec]
  (utils/check v spec))

;;; Definitions
(s/def ::displayvideo-client ::displayvideo/client)
(s/def ::order-by ::displayvideo/order-by)
(s/def ::filter-expr ::displayvideo/filter-expr)
(s/def ::limit ::displayvideo/limit)
(s/def ::update-mask ::displayvideo/update-mask)
(s/def ::advertiser-id ::advertiser/advertiser-id)
(s/def ::advertiser ::displayvideo/advertiser)
(s/def ::advertisers ::displayvideo/advertisers)
(s/def ::create-asset-request ::displayvideo/create-asset-request)
(s/def ::create-asset-response ::displayvideo/create-asset-response)
(s/def ::creative-id ::creative/creative-id)
(s/def ::creative ::displayvideo/creative)
(s/def ::creatives ::displayvideo/creatives)
(s/def ::campaign-id ::campaign/campaign-id)
(s/def ::campaign ::displayvideo/campaign)
(s/def ::campaigns ::displayvideo/campaigns)
(s/def ::line-item-id ::line-item/line-item-id)
(s/def ::line-item ::displayvideo/line-item)
(s/def ::line-items ::displayvideo/line-items)
(s/def ::insertion-order-id ::insertion-order/insertion-order-id)
(s/def ::insertion-order ::displayvideo/insertion-order)
(s/def ::insertion-orders ::displayvideo/insertion-orders)
(s/def ::assigned-targeting-option ::displayvideo/assigned-targeting-option)
(s/def ::targeting-type ::assigned-targeting-option/targeting-type)
(s/def ::assigned-targeting-option-id ::assigned-targeting-option/assigned-targeting-option-id)
(s/def ::assigned-targeting-options ::displayvideo/assigned-targeting-options)
