(ns com.adgoji.displayvideo-spec.displayvideo
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser :as advertiser]
   [com.adgoji.displayvideo-spec.displayvideo.create-asset-request
    :as create-asset-request]
   [com.adgoji.displayvideo-spec.displayvideo.create-asset-response
    :as create-asset-response]
   [com.adgoji.displayvideo-spec.displayvideo.creative :as creative]
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.displayvideo-spec.displayvideo.campaign :as campaign]
   [com.adgoji.displayvideo-spec.displayvideo.line-item :as line-item]
   [com.adgoji.displayvideo-spec.displayvideo.insertion-order :as insertion-order]
   [com.adgoji.displayvideo-spec.displayvideo.assigned-targeting-option
    :as assigned-targeting-option]
   [com.adgoji.displayvideo-spec.displayvideo.targeting-option
    :as targeting-option]
   [com.adgoji.displayvideo-spec.displayvideo.targeting-type
    :as targeting-type]
   [com.adgoji.displayvideo-spec.displayvideo.geo-region-search-terms
    :as geo-region-search-terms]
   [com.adgoji.displayvideo-spec.displayvideo.poi-search-terms
    :as poi-search-terms]
   [com.adgoji.displayvideo-spec.displayvideo.business-chain-search-terms
    :as business-chain-search-terms]
   [com.adgoji.displayvideo-spec.displayvideo.search-targeting-option-request
    :as search-targeting-option-request])
  (:import
   (com.google.api.services.displayvideo.v2 DisplayVideo)))

(s/def ::client (partial instance? DisplayVideo))
(s/def ::filter-expr string?)
(s/def ::order-by string?)
(s/def ::limit int?)

(s/def ::advertiser
  (spec/only-keys :req-un [::advertiser/partner-id
                           ::advertiser/display-name
                           ::advertiser/entity-status
                           ::advertiser/general-config
                           ::advertiser/ad-server-config
                           ::advertiser/creative-config]
                  :opt-un [::advertiser/name
                           ::advertiser/advertiser-id
                           ::advertiser/update-time
                           ::advertiser/prisma-enabled
                           ::advertiser/data-access-config
                           ::advertiser/integration-details
                           ::advertiser/serving-config
                           ::advertiser/billing-config]))

(s/def ::advertisers
  (s/coll-of ::advertiser :distinct true :into []))

(s/def ::update-mask
  (s/coll-of keyword? :distinct true :into []))

(s/def ::create-asset-request
  (spec/only-keys :req-un [::create-asset-request/filename]))

(s/def ::create-asset-response
  (spec/only-keys :req-un [::create-asset-response/asset]))

(s/def ::creative
  (spec/only-keys :req-un [::creative/display-name
                           ::creative/entity-status
                           ::creative/creative-type
                           ::creative/hosting-source
                           ::creative/dimensions]
                  :opt-un [::creative/name
                           ::creative/advertiser-id
                           ::creative/creative-id
                           ::creative/assets
                           ::creative/cm-placement-id
                           ::creative/update-time
                           ::creative/create-time
                           ::creative/dynamic
                           ::creative/additional-dimensions
                           ::creative/media-duration
                           ::creative/creative-attributes
                           ::creative/review-status
                           ::creative/exit-events
                           ::creative/timer-events
                           ::creative/counter-events
                           ::creative/appended-tag
                           ::creative/integration-code
                           ::creative/notes
                           ::creative/ias-campaign-monitoring
                           ::creative/companion-creative-ids
                           ::creative/skippable
                           ::creative/skip-offset
                           ::creative/progress-offset
                           ::creative/universal-ad-id
                           ::creative/third-party-urls
                           ::creative/transcodes
                           ::creative/tracker-urls
                           ::creative/js-tracker-url
                           ::creative/cm-tracking-ad
                           ::creative/oba-icon
                           ::creative/third-party-tag
                           ::creative/require-mraid
                           ::creative/require-html5
                           ::creative/require-ping-for-attribution
                           ::creative/expanding-direction
                           ::creative/expand-on-hover
                           ::creative/vast-tag-url
                           ::creative/vpaid
                           ::creative/html5-video
                           ::creative/line-item-ids
                           ::creative/mp3-audio
                           ::creative/ogg-audio]))

(s/def ::creatives
  (s/coll-of ::creative :distinct true :into []))

(s/def ::campaign
  (spec/only-keys :req-un [::campaign/display-name
                           ::campaign/entity-status
                           ::campaign/campaign-goal
                           ::campaign/campaign-flight
                           ::campaign/frequency-cap]
                  :opt-un [::campaign/name
                           ::advertiser/advertiser-id
                           ::campaign/campaign-id
                           ::campaign/update-time
                           ::campaign/campaign-budgets]))

(s/def ::campaigns
  (s/coll-of ::campaign :distinct true :into []))

(s/def ::line-item
  (spec/only-keys :req-un [::line-item/bid-strategy
                           ::line-item/budget
                           ::line-item/display-name
                           ::line-item/entity-status
                           ::line-item/flight
                           ::line-item/frequency-cap
                           ::line-item/insertion-order-id
                           ::line-item/line-item-type
                           ::line-item/pacing
                           ::line-item/partner-revenue-model]
                  :opt-un [::advertiser/advertiser-id
                           ::campaign/campaign-id
                           ::line-item/conversion-counting
                           ::line-item/creative-ids
                           ::line-item/exclude-new-changes
                           ::line-item/integration-details
                           ::line-item/line-item-id
                           ::line-item/mobile-app
                           ::line-item/name
                           ::line-item/partner-costs
                           ::line-item/reservation-type
                           ::line-item/targeting-expansion
                           ::line-item/update-time
                           ::line-item/warning-messages
                           ::line-item/youtube-partner-settings]))

(s/def ::line-items
  (s/coll-of ::line-item :distinct true :into []))

(s/def ::insertion-order
  (spec/only-keys :req-un [::insertion-order/display-name
                           ::campaign/campaign-id
                           ::insertion-order/entity-status
                           ::insertion-order/pacing
                           ::insertion-order/frequency-cap
                           ::insertion-order/performance-goal
                           ::insertion-order/budget]
                  :opt-un [::insertion-order/name
                           ::advertiser/advertiser-id
                           ::insertion-order/insertion-order-id
                           ::insertion-order/insertion-order-type
                           ::insertion-order/update-time
                           ::insertion-order/partner-costs
                           ::insertion-order/integration-details
                           ::insertion-order/bid-strategy
                           ::insertion-order/reservation-type
                           ::insertion-order/billable-outcome]))

(s/def ::insertion-orders
  (s/coll-of ::insertion-order :distinct true :into []))

(s/def ::assigned-targeting-option
  (spec/only-keys :opt-un [::assigned-targeting-option/name
                           ::assigned-targeting-option/assigned-targeting-option-id
                           ::assigned-targeting-option/assigned-targeting-option-id-alias
                           ::targeting-type/targeting-type
                           ::assigned-targeting-option/inheritance
                           ::assigned-targeting-option/channel-details
                           ::assigned-targeting-option/app-category-details
                           ::assigned-targeting-option/app-details
                           ::assigned-targeting-option/url-details
                           ::assigned-targeting-option/day-and-time-details
                           ::assigned-targeting-option/age-range-details
                           ::assigned-targeting-option/regional-location-list-details
                           ::assigned-targeting-option/proximity-location-list-details
                           ::assigned-targeting-option/gender-details
                           ::assigned-targeting-option/video-player-size-details
                           ::assigned-targeting-option/user-rewarded-content-details
                           ::assigned-targeting-option/parental-status-details
                           ::assigned-targeting-option/content-instream-position-details
                           ::assigned-targeting-option/content-outstream-position-details
                           ::assigned-targeting-option/device-type-details
                           ::assigned-targeting-option/audience-group-details
                           ::assigned-targeting-option/browser-details
                           ::assigned-targeting-option/household-income-details
                           ::assigned-targeting-option/on-screen-position-details
                           ::assigned-targeting-option/carrier-and-isp-details
                           ::assigned-targeting-option/keyword-details
                           ::assigned-targeting-option/negative-keyword-list-details
                           ::assigned-targeting-option/operating-system-details
                           ::assigned-targeting-option/device-make-model-details
                           ::assigned-targeting-option/environment-details
                           ::assigned-targeting-option/inventory-source-details
                           ::assigned-targeting-option/category-details
                           ::assigned-targeting-option/viewability-details
                           ::assigned-targeting-option/authorized-seller-status-details
                           ::assigned-targeting-option/language-details
                           ::assigned-targeting-option/geo-region-details
                           ::assigned-targeting-option/inventory-source-group-details
                           ::assigned-targeting-option/digital-content-label-exclusion-details
                           ::assigned-targeting-option/sensitive-category-exclusion-details
                           ::assigned-targeting-option/exchange-details
                           ::assigned-targeting-option/sub-exchange-details
                           ::assigned-targeting-option/third-party-verifier-details
                           ::assigned-targeting-option/poi-details
                           ::assigned-targeting-option/business-chain-details
                           ::assigned-targeting-option/content-duration-details
                           ::assigned-targeting-option/content-stream-type-details
                           ::assigned-targeting-option/native-content-position-details
                           ::assigned-targeting-option/omid-details
                           ::assigned-targeting-option/audio-content-type-details
                           ::assigned-targeting-option/content-genre-details
                           ::assigned-targeting-option/youtube-video-details
                           ::assigned-targeting-option/youtube-channel-details
                           ::assigned-targeting-option/session-position-details]))

(s/def ::assigned-targeting-options
  (s/coll-of ::assigned-targeting-option))

(s/def ::targeting-option
  (spec/only-keys :opt-un [::targeting-option/name
                           ::targeting-option/targeting-option-id
                           ::targeting-type/targeting-type
                           ::targeting-option/digital-content-label-details
                           ::targeting-option/sensitive-category-details
                           ::targeting-option/app-category-details
                           ::targeting-option/on-screen-position-details
                           ::targeting-option/app-category-details
                           ::targeting-option/content-outstream-position-details
                           ::targeting-option/content-instream-position-details
                           ::targeting-option/video-player-size-details
                           ::targeting-option/age-range-details
                           ::targeting-option/parental-status-details
                           ::targeting-option/user-rewarded-content-details
                           ::targeting-option/household-income-details
                           ::targeting-option/gender-details
                           ::targeting-option/device-details
                           ::targeting-option/browser-details
                           ::targeting-option/carrier-and-isp-details
                           ::targeting-option/environment-details
                           ::targeting-option/operating-system-details
                           ::targeting-option/device-make-model-details
                           ::targeting-option/viewability-details
                           ::targeting-option/category-details
                           ::targeting-option/language-details
                           ::targeting-option/authorized-seller-status-details
                           ::targeting-option/geo-region-details
                           ::targeting-option/exchange-details
                           ::targeting-option/sub-exchange-details
                           ::targeting-option/poi-details
                           ::targeting-option/business-chain-details
                           ::targeting-option/content-duration-details
                           ::targeting-option/content-stream-type-details
                           ::targeting-option/native-content-position-details
                           ::targeting-option/omid-details
                           ::targeting-option/audio-content-type-details
                           ::targeting-option/content-genre-details]))

(s/def ::targeting-options
  (s/coll-of ::targeting-option :distinct true :into []))

(s/def ::search-targeting-option-request
  (spec/only-keys :req-un [::advertiser/advertiser-id]
                  :opt-un [::business-chain-search-terms/business-chain-search-terms
                           ::poi-search-terms/poi-search-terms
                           ::geo-region-search-terms/geo-region-search-terms
                           ::search-targeting-option-request/page-size
                           ::search-targeting-option-request/page-token]))
