(ns com.adgoji.campaigns-assigned-targeting-options.core
  (:require
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]
   [com.adgoji.sdk-client-utils.interface :as sdk-client-utils]
   [com.adgoji.spec.interface :as spec])
  (:import
   (com.google.api.services.displayvideo.v2 DisplayVideo DisplayVideo$Advertisers$Campaigns$TargetingTypes$AssignedTargetingOptions$List)))

(defn get-by-id
  [^DisplayVideo client
   ^Long advertiser-id
   ^Long campaign-id
   ^String targeting-type
   ^String assigned-targeting-option-id]
  (-> client
      (.advertisers)
      (.campaigns)
      (.targetingTypes)
      (.assignedTargetingOptions)
      (.get advertiser-id
            campaign-id
            targeting-type
            assigned-targeting-option-id)
      (sdk-client-utils/execute-and-convert)
      (spec/check ::displayvideo-spec/assigned-targeting-option)))

(defn- fetch-assigned-targeting-options-page
  [^DisplayVideo$Advertisers$Campaigns$TargetingTypes$AssignedTargetingOptions$List request
   ^String next-page-token]
  (-> request
      (.setPageToken next-page-token)
      (sdk-client-utils/execute-and-convert)))

(defn get-list
  [^DisplayVideo client
   ^Long advertiser-id
   ^Long campaign-id
   ^String targeting-type
   {:keys [order-by filter-expr limit]}]
  (let [request (-> client
                    (.advertisers)
                    (.campaigns)
                    (.targetingTypes)
                    (.assignedTargetingOptions)
                    (.list advertiser-id campaign-id targeting-type))]
    (when order-by
      (.setOrderBy ^DisplayVideo$Advertisers$Campaigns$TargetingTypes$AssignedTargetingOptions$List request order-by))
    (when filter-expr
      (.setFilter ^DisplayVideo$Advertisers$Campaigns$TargetingTypes$AssignedTargetingOptions$List request filter-expr))
    (-> (sdk-client-utils/execute-and-convert-paginated
         (partial fetch-assigned-targeting-options-page request)
         :assigned-targeting-options
         limit)
        (spec/check ::displayvideo-spec/assigned-targeting-options))))
