(ns com.adgoji.spec.interface
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.utils :as utils]))

(defn check
  [v spec]
  (utils/check v spec))

(defmacro only-keys
  [& {:keys [req req-un opt opt-un] :as args}]
  `(s/merge (s/map-of ~(set (concat req
                                    (map (comp keyword name) req-un)
                                    opt
                                    (map (comp keyword name) opt-un)))
                      any?)
            (s/keys ~@(apply concat (vec args)))))
