(ns com.adgoji.displayvideo-spec.interface
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.displayvideo :as displayvideo]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser :as advertiser]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser-location-list
    :as advertiser-location-list]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser-targeting-type
    :as advertiser-targeting-type]
   [com.adgoji.displayvideo-spec.displayvideo.assigned-location
    :as assigned-location]
   [com.adgoji.displayvideo-spec.displayvideo.assigned-targeting-option
    :as assigned-targeting-option]
   [com.adgoji.displayvideo-spec.displayvideo.campaign :as campaign]
   [com.adgoji.displayvideo-spec.displayvideo.campaign-targeting-type
    :as campaign-targeting-type]
   [com.adgoji.displayvideo-spec.displayvideo.channel :as channel]
   [com.adgoji.displayvideo-spec.displayvideo.creative :as creative]
   [com.adgoji.displayvideo-spec.displayvideo.get-list-advertiser-targeting-type
    :as get-list-advertiser-targeting-type]
   [com.adgoji.displayvideo-spec.displayvideo.insertion-order
    :as insertion-order]
   [com.adgoji.displayvideo-spec.displayvideo.insertion-order-get-list-targeting-type
    :as insertion-order-get-list-targeting-type]
   [com.adgoji.displayvideo-spec.displayvideo.insertion-order-targeting-type
    :as insertion-order-targeting-type]
   [com.adgoji.displayvideo-spec.displayvideo.line-item :as line-item]
   [com.adgoji.displayvideo-spec.displayvideo.line-item-get-list-targeting-type
    :as line-item-get-list-targeting-type]
   [com.adgoji.displayvideo-spec.displayvideo.line-item-targeting-type
    :as line-item-targeting-type]
   [com.adgoji.displayvideo-spec.displayvideo.search-targeting-type
    :as search-targeting-type]
   [com.adgoji.displayvideo-spec.displayvideo.site
    :as site]
   [com.adgoji.displayvideo-spec.displayvideo.targeting-type
    :as targeting-type]))

;;; Definitions
(s/def ::displayvideo-client ::displayvideo/client)
(s/def ::order-by ::displayvideo/order-by)
(s/def ::filter-expr ::displayvideo/filter-expr)
(s/def ::limit ::displayvideo/limit)
(s/def ::update-mask ::displayvideo/update-mask)
(s/def ::advertiser-id ::advertiser/advertiser-id)
(s/def ::advertiser ::displayvideo/advertiser)
(s/def ::advertisers ::displayvideo/advertisers)
(s/def ::create-asset-request ::displayvideo/create-asset-request)
(s/def ::create-asset-response ::displayvideo/create-asset-response)
(s/def ::creative-id ::creative/creative-id)
(s/def ::creative ::displayvideo/creative)
(s/def ::creatives ::displayvideo/creatives)
(s/def ::campaign-id ::campaign/campaign-id)
(s/def ::campaign ::displayvideo/campaign)
(s/def ::campaigns ::displayvideo/campaigns)
(s/def ::channel ::displayvideo/channel)
(s/def ::channel-id ::channel/channel-id)
(s/def ::channels ::displayvideo/channels)
(s/def ::line-item-id ::line-item/line-item-id)
(s/def ::line-item-ids ::line-item/line-item-ids)
(s/def ::line-item ::displayvideo/line-item)
(s/def ::line-items ::displayvideo/line-items)
(s/def ::insertion-order-id ::insertion-order/insertion-order-id)
(s/def ::insertion-order ::displayvideo/insertion-order)
(s/def ::insertion-orders ::displayvideo/insertion-orders)
(s/def ::assigned-targeting-option ::displayvideo/assigned-targeting-option)
(s/def ::search-targeting-type ::search-targeting-type/targeting-type)
(s/def ::targeting-type ::targeting-type/targeting-type)
(s/def ::assigned-targeting-option-id ::assigned-targeting-option/assigned-targeting-option-id)
(s/def ::assigned-targeting-options ::displayvideo/assigned-targeting-options)
(s/def ::targeting-option ::displayvideo/targeting-option)
(s/def ::targeting-options ::displayvideo/targeting-options)
(s/def ::bulk-edit-assigned-options-request ::displayvideo/bulk-edit-assigned-targeting-options-request)
(s/def ::bulk-edit-assigned-options-response ::displayvideo/bulk-edit-assigned-targeting-options-response)
(s/def ::bulk-list-assigned-options-response ::displayvideo/bulk-list-assigned-targeting-options-response)
(s/def ::search-targeting-option-request ::displayvideo/search-targeting-option-request)
(s/def ::advertiser-targeting-type ::advertiser-targeting-type/targeting-type)
(s/def ::campaign-targeting-type ::campaign-targeting-type/targeting-type)
(s/def ::get-list-advertiser-targeting-type ::get-list-advertiser-targeting-type/targeting-type)
(s/def ::insertion-order-targeting-type ::insertion-order-targeting-type/targeting-type)
(s/def ::insertion-order-get-list-targeting-type ::insertion-order-get-list-targeting-type/targeting-type)
(s/def ::line-item-targeting-type ::line-item-targeting-type/targeting-type)
(s/def ::line-item-get-list-targeting-type ::line-item-get-list-targeting-type/targeting-type)
(s/def ::bulk-edit-sites-request ::displayvideo/bulk-edit-sites-request)
(s/def ::replace-sites-request ::displayvideo/replace-sites-request)
(s/def ::site ::displayvideo/site)
(s/def ::sites ::displayvideo/sites)
(s/def ::url-or-app-id ::site/url-or-app-id)
(s/def ::location-list ::displayvideo/location-list)
(s/def ::location-lists ::displayvideo/location-lists)
(s/def ::location-list-id ::advertiser-location-list/location-list-id)
(s/def ::assigned-location ::displayvideo/assigned-location)
(s/def ::assigned-locations ::displayvideo/assigned-locations)
(s/def ::bulk-edit-assigned-locations-request ::displayvideo/bulk-edit-assigned-locations-request)
(s/def ::assigned-location-id ::assigned-location/assigned-location-id)
