(ns com.adgoji.displayvideo-api.google-audiences
  (:require
   [com.adgoji.google-audiences.interface :as google-audiences]
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]))

(defn get-by-id
  "Returns a Google audience."
  [client google-audience-id accessor-map]
  (google-audiences/get-by-id client google-audience-id accessor-map))

(s/fdef get-by-id
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :google-audience-id ::displayvideo-spec/google-audience-id
               :accessor-map ::displayvideo-spec/accessor)
  :ret ::displayvideo-spec/google-audience)

(defn get-list
  "Returns a list of Google audiences."
  [client accessor-map opts]
  (google-audiences/get-list client accessor-map opts))

(s/fdef get-list
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :accessor-map ::displayvideo-spec/accessor
               :opts (s/keys :opt-un [::displayvideo-spec/order-by
                                      ::displayvideo-spec/filter-expr
                                      ::displayvideo-spec/limit]))
  :ret ::displayvideo-spec/google-audiences)
