(ns com.adgoji.displayvideo-spec.displayvideo.targeting-option
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.displayvideo.carrier-and-isp-targeting-option-details
    :as carrier-and-isp-details]
   [com.adgoji.displayvideo-spec.displayvideo.age-range-targeting-option-details
    :as age-range-details]
   [com.adgoji.displayvideo-spec.displayvideo.common-assigned-targeting-option-details
    :as common-details]
   [com.adgoji.displayvideo-spec.displayvideo.content-instream-position-targeting-option-details
    :as content-instream-position-details]
   [com.adgoji.displayvideo-spec.displayvideo.content-outstream-position-targeting-option-details
    :as content-outstream-position-details]
   [com.adgoji.displayvideo-spec.displayvideo.device-type-targeting-option-details
    :as device-type-details]
   [com.adgoji.displayvideo-spec.displayvideo.digital-content-label-targeting-option-details
    :as digital-content-label-details]
   [com.adgoji.displayvideo-spec.displayvideo.environment-targeting-option-details
    :as environment-details]
   [com.adgoji.displayvideo-spec.displayvideo.gender-targeting-option-details
    :as gender-details]
   [com.adgoji.displayvideo-spec.displayvideo.household-income-targeting-option-details
    :as household-income-details]
   [com.adgoji.displayvideo-spec.displayvideo.on-screen-position-targeting-option-details
    :as on-screen-position-details]
   [com.adgoji.displayvideo-spec.displayvideo.parental-status-targeting-option-details
    :as parental-status-details]
   [com.adgoji.displayvideo-spec.displayvideo.sensitive-category-targeting-option-details
    :as sensitive-category-details]
   [com.adgoji.displayvideo-spec.displayvideo.user-rewarded-content-targeting-option-details
    :as user-rewarded-content-details]
   [com.adgoji.displayvideo-spec.displayvideo.video-player-size-targeting-option-details
    :as video-player-size-details]
   [com.adgoji.displayvideo-spec.displayvideo.viewability-targeting-option-details
    :as viewability-details]
   [com.adgoji.displayvideo-spec.displayvideo.authorized-seller-status-targeting-option-details
    :as authorized-seller-status-details]
   [com.adgoji.displayvideo-spec.displayvideo.geo-region-targeting-option-details
    :as geo-region-details]
   [com.adgoji.displayvideo-spec.displayvideo.exchange-targeting-option-details
    :as exchange-details]
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.displayvideo-spec.displayvideo.poi-targeting-option-details
    :as poi-details]
   [com.adgoji.displayvideo-spec.displayvideo.business-chain-targeting-option-details
    :as business-chain-details]
   [com.adgoji.displayvideo-spec.displayvideo.content-duration-targeting-option-details
    :as content-duration-details]
   [com.adgoji.displayvideo-spec.displayvideo.content-stream-type-targeting-option-details
    :as content-stream-type-details]
   [com.adgoji.displayvideo-spec.displayvideo.native-content-position-targeting-option-details
    :as native-content-position-details]
   [com.adgoji.displayvideo-spec.displayvideo.omid-targeting-option-details
    :as omid-details]
   [com.adgoji.displayvideo-spec.displayvideo.audio-content-type-targeting-option-details
    :as audio-content-type-details]))

(s/def ::name string?)

(s/def ::targeting-option-id string?)

(s/def ::digital-content-label-details
  (spec/only-keys :opt-un [::digital-content-label-details/content-rating-tier]))

(s/def ::sensitive-category-details
  (spec/only-keys :opt-un [::sensitive-category-details/sensitive-category]))

(s/def ::app-category-details
  (spec/only-keys :opt-un [::common-details/display-name]))

(s/def ::on-screen-position-details
  (spec/only-keys :opt-un [::on-screen-position-details/on-screen-position]))

(s/def ::content-outstream-position-details
  (spec/only-keys :opt-un [::content-outstream-position-details/content-outstream-position]))

(s/def ::content-instream-position-details
  (spec/only-keys :opt-un [::content-instream-position-details/content-instream-position]))

(s/def ::video-player-size-details
  (spec/only-keys :opt-un [::video-player-size-details/video-player-size]))

(s/def ::age-range-details
  (spec/only-keys :opt-un [::age-range-details/age-range]))

(s/def ::parental-status-details
  (spec/only-keys :opt-un [::parental-status-details/parental-status]))

(s/def ::user-rewarded-content-details
  (spec/only-keys :opt-un [::user-rewarded-content-details/user-rewarded-content]))

(s/def ::household-income-details
  (spec/only-keys :opt-un [::household-income-details/household-income]))

(s/def ::gender-details
  (spec/only-keys :opt-un [::gender-details/gender]))

(s/def ::device-details
  (spec/only-keys :opt-un [::device-type-details/device-type]))

(s/def ::browser-details
  (spec/only-keys :opt-un [::common-details/display-name]))

(s/def ::carrier-and-isp-details
  (spec/only-keys :opt-un [::common-details/display-name
                           ::carrier-and-isp-details/type]))
(s/def ::environment-details
  (spec/only-keys :opt-un [::environment-details/environment]))

(s/def ::operating-system-details
  (spec/only-keys :opt-un [::common-details/display-name]))

(s/def ::device-make-model-details
  (spec/only-keys :opt-un [::common-details/display-name]))

(s/def ::viewability-details
  (spec/only-keys :opt-un [::viewability-details/viewability]))

(s/def ::category-details
  (spec/only-keys :opt-un [::common-details/display-name]))

(s/def ::language-details
  (spec/only-keys :opt-un [::common-details/display-name]))

(s/def ::authorized-seller-status-details
  (spec/only-keys :opt-un [::authorized-seller-status-details/authorized-seller-status]))

(s/def ::geo-region-details
  (spec/only-keys :opt-un [::common-details/display-name
                           ::geo-region-details/geo-region-type]))

(s/def ::exchange-details
  (spec/only-keys :opt-un [::exchange-details/exchange]))

(s/def ::sub-exchange-details
  (spec/only-keys :opt-un [::common-details/display-name]))

(s/def ::poi-details
  (spec/only-keys :opt-un [::poi-details/latitude
                           ::poi-details/longitude
                           ::common-details/display-name]))

(s/def ::business-chain-details
  (spec/only-keys :opt-un [::business-chain-details/business-chain
                           ::business-chain-details/geo-region
                           ::geo-region-details/geo-region-type]))

(s/def ::content-duration-details
  (spec/only-keys :opt-un [::content-duration-details/content-duration]))

(s/def ::content-stream-type-details
  (spec/only-keys :opt-un [::content-stream-type-details/content-stream-type]))

(s/def ::native-content-position-details
  (spec/only-keys :opt-un [::native-content-position-details/content-position]))

(s/def ::omid-details
  (spec/only-keys :opt-un [::omid-details/omid]))

(s/def ::audio-content-type-details
  (spec/only-keys :opt-un [::audio-content-type-details/audio-content-type]))

(s/def ::content-genre-details
  (spec/only-keys :opt-un [::common-details/display-name]))
