(ns com.adgoji.displayvideo-api.advertisers.assigned-targeting-options
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.advertisers-assigned-targeting-options.interface
    :as assigned-targeting-options]
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]))

(defn create
  "Assigns a targeting option to an advertiser"
  [client advertiser-id targeting-type assigned-targeting-option]
  (assigned-targeting-options/create client
                                     advertiser-id
                                     targeting-type
                                     assigned-targeting-option))

(s/fdef create
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :targeting-type ::displayvideo-spec/advertiser-targeting-type
               :assigned-targeting-option ::displayvideo-spec/assigned-targeting-option)
  :ret ::displayvideo-spec/assigned-targeting-option)

(defn delete
  "Delete an assigned-targeting-option by `advertiser-id` and
  `assigned-targeting-option-id`."
  [client advertiser-id targeting-type assigned-targeting-option-id]
  (assigned-targeting-options/delete client
                                     advertiser-id
                                     targeting-type
                                     assigned-targeting-option-id))

(s/fdef delete
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :targeting-type ::displayvideo-spec/advertiser-targeting-type
               :assigned-targeting-option-id ::displayvideo-spec/assigned-targeting-option-id)
  :ret (s/and map? empty?))

(defn get-by-id
  "Returns a single assigned-targeting-option by `assigned-targeting-option-id`."
  [client advertiser-id targeting-type assigned-targeting-option-id]
  (assigned-targeting-options/get-by-id client
                                        advertiser-id
                                        targeting-type
                                        assigned-targeting-option-id))

(s/fdef get-by-id
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :targeting-type ::displayvideo-spec/get-list-advertiser-targeting-type
               :assigned-targeting-option-id ::displayvideo-spec/assigned-targeting-option-id)
  :ret ::displayvideo-spec/assigned-targeting-option)

(defn get-list
  "Returns a list of all assigned targeting options of an advertiser"
  [client advertiser-id targeting-type opts]
  (assigned-targeting-options/get-list client
                                       advertiser-id
                                       targeting-type
                                       opts))

(s/fdef get-list
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :targeting-type ::displayvideo-spec/get-list-advertiser-targeting-type
               :opts (s/keys :opt-un [::displayvideo-spec/order-by
                                      ::displayvideo-spec/filter-expr
                                      ::displayvideo-spec/limit]))
  :ret ::displayvideo-spec/assigned-targeting-options)
