(ns com.adgoji.displayvideo-spec.displayvideo
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.common :as spec.common]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser :as advertiser]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser.location-list
    :as advertiser.location-list]
   [com.adgoji.displayvideo-spec.displayvideo.assigned-location
    :as assigned-location]
   [com.adgoji.displayvideo-spec.displayvideo.assigned-targeting-option
    :as assigned-targeting-option]
   [com.adgoji.displayvideo-spec.displayvideo.bulk-edit-assigned-targeting-options-request
    :as bulk-edit-assigned-targeting-options-request]
   [com.adgoji.displayvideo-spec.displayvideo.bulk-edit-assigned-targeting-options-response
    :as bulk-edit-assigned-targeting-options-response]
   [com.adgoji.displayvideo-spec.displayvideo.bulk-list-assigned-targeting-options-response
    :as bulk-list-assigned-targeting-options-response]
   [com.adgoji.displayvideo-spec.displayvideo.bulk-update-line-items-request
    :as bulk-update-line-items-request]
   [com.adgoji.displayvideo-spec.displayvideo.bulk-update-line-items-response
    :as bulk-update-line-items-response]
   [com.adgoji.displayvideo-spec.displayvideo.business-chain-search-terms
    :as business-chain-search-terms]
   [com.adgoji.displayvideo-spec.displayvideo.campaign :as campaign]
   [com.adgoji.displayvideo-spec.displayvideo.channel :as channel]
   [com.adgoji.displayvideo-spec.displayvideo.create-asset-request
    :as create-asset-request]
   [com.adgoji.displayvideo-spec.displayvideo.create-asset-response
    :as create-asset-response]
   [com.adgoji.displayvideo-spec.displayvideo.creative :as creative]
   [com.adgoji.displayvideo-spec.displayvideo.geo-region-search-terms
    :as geo-region-search-terms]
   [com.adgoji.displayvideo-spec.displayvideo.google-audience
    :as google-audience]
   [com.adgoji.displayvideo-spec.displayvideo.insertion-order
    :as insertion-order]
   [com.adgoji.displayvideo-spec.displayvideo.line-item :as line-item]
   [com.adgoji.displayvideo-spec.displayvideo.partner :as partner]
   [com.adgoji.displayvideo-spec.displayvideo.poi-search-terms
    :as poi-search-terms]
   [com.adgoji.displayvideo-spec.displayvideo.search-targeting-option-request
    :as search-targeting-option-request]
   [com.adgoji.displayvideo-spec.displayvideo.site :as site]
   [com.adgoji.displayvideo-spec.displayvideo.targeting-option
    :as targeting-option]
   [com.adgoji.displayvideo-spec.displayvideo.targeting-type
    :as targeting-type]
   [com.adgoji.spec.interface :as spec])
  (:import
   (com.google.api.services.displayvideo.v3 DisplayVideo)))

(s/def ::client (partial instance? DisplayVideo))
(s/def ::filter-expr string?)
(s/def ::order-by string?)
(s/def ::limit int?)

(s/def ::advertiser ::advertiser/spec)

(s/def ::advertiser-update ::advertiser/update-spec)

(s/def ::advertisers
  (s/coll-of ::advertiser :distinct true :into []))

(s/def ::update-mask ::spec.common/update-mask)

(s/def ::create-asset-request
  (spec/only-keys :req-un [::create-asset-request/filename]))

(s/def ::create-asset-response
  (spec/only-keys :req-un [::create-asset-response/asset]))

(s/def ::creative ::creative/spec)

(s/def ::creative-update ::creative/update-spec)

(s/def ::creatives
  (s/coll-of ::creative :distinct true :into []))

(s/def ::campaign ::campaign/spec)

(s/def ::campaign-update ::campaign/update-spec)

(s/def ::campaigns
  (s/coll-of ::campaign :distinct true :into []))

(s/def ::line-item ::line-item/spec)

(s/def ::line-item-update ::line-item/update-spec)

(s/def ::line-items
  (s/coll-of ::line-item :distinct true :into []))

(s/def ::bulk-update-line-items-request
  ::bulk-update-line-items-request/spec)

(s/def ::bulk-update-line-items-response
  ::bulk-update-line-items-response/spec)

(s/def ::insertion-order ::insertion-order/spec)

(s/def ::insertion-order-update ::insertion-order/update-spec)

(s/def ::insertion-orders
  (s/coll-of ::insertion-order :distinct true :into []))

(s/def ::assigned-targeting-option ::assigned-targeting-option/spec)

(s/def ::assigned-targeting-options
  (s/coll-of ::assigned-targeting-option :into []))

(s/def ::targeting-option
  (spec/only-keys :opt-un [::targeting-option/name
                           ::targeting-option/targeting-option-id
                           ::targeting-type/targeting-type
                           ::targeting-option/digital-content-label-details
                           ::targeting-option/sensitive-category-details
                           ::targeting-option/app-category-details
                           ::targeting-option/on-screen-position-details
                           ::targeting-option/app-category-details
                           ::targeting-option/content-outstream-position-details
                           ::targeting-option/content-instream-position-details
                           ::targeting-option/video-player-size-details
                           ::targeting-option/age-range-details
                           ::targeting-option/parental-status-details
                           ::targeting-option/user-rewarded-content-details
                           ::targeting-option/household-income-details
                           ::targeting-option/gender-details
                           ::targeting-option/device-details
                           ::targeting-option/browser-details
                           ::targeting-option/carrier-and-isp-details
                           ::targeting-option/environment-details
                           ::targeting-option/operating-system-details
                           ::targeting-option/device-make-model-details
                           ::targeting-option/viewability-details
                           ::targeting-option/category-details
                           ::targeting-option/language-details
                           ::targeting-option/authorized-seller-status-details
                           ::targeting-option/geo-region-details
                           ::targeting-option/exchange-details
                           ::targeting-option/sub-exchange-details
                           ::targeting-option/poi-details
                           ::targeting-option/business-chain-details
                           ::targeting-option/content-duration-details
                           ::targeting-option/content-stream-type-details
                           ::targeting-option/native-content-position-details
                           ::targeting-option/omid-details
                           ::targeting-option/audio-content-type-details
                           ::targeting-option/content-genre-details]))

(s/def ::targeting-options
  (s/coll-of ::targeting-option :into []))

(s/def ::search-targeting-option-request
  (spec/only-keys :req-un [::advertiser/advertiser-id]
                  :opt-un [::business-chain-search-terms/business-chain-search-terms
                           ::poi-search-terms/poi-search-terms
                           ::geo-region-search-terms/geo-region-search-terms
                           ::search-targeting-option-request/page-size
                           ::search-targeting-option-request/page-token]))

(s/def ::bulk-edit-assigned-targeting-options-request
  ::bulk-edit-assigned-targeting-options-request/spec)

(s/def ::bulk-edit-assigned-targeting-options-response
  ::bulk-edit-assigned-targeting-options-response/spec)

(s/def ::bulk-list-assigned-targeting-options-response
  ::bulk-list-assigned-targeting-options-response/spec)

(s/def ::channel ::channel/spec)

(s/def ::channel-update ::channel/update-spec)

(s/def ::channels
  (s/coll-of ::channel :distinct true :into []))

(s/def ::replace-sites-request
  (spec/only-keys :opt-un [::site/new-sites
                           ::advertiser/advertiser-id
                           ::partner/partner-id]))

(s/def ::bulk-edit-sites-request
  (spec/only-keys :opt-un [::site/deleted-sites
                           ::site/created-sites
                           ::advertiser/advertiser-id
                           ::partner/partner-id]))
(s/def ::site
  (spec/only-keys :req-un [::site/url-or-app-id]
                  :opt-un [::site/name]))

(s/def ::sites
  (s/coll-of ::site :distinct true :into []))

(s/def ::location-list ::advertiser.location-list/spec)

(s/def ::location-list-update ::advertiser.location-list/update-spec)

(s/def ::location-lists
  (s/coll-of ::location-list :distinct true :into []))

(s/def ::bulk-edit-assigned-locations-request
  (spec/only-keys :opt-un [::assigned-location/deleted-assigned-locations
                           ::assigned-location/created-assigned-locations]))

(s/def ::assigned-location
  (spec/only-keys :req-un [::assigned-location/targeting-option-id]
                  :opt-un [::advertiser.location-list/location-list-id
                           ::assigned-location/name
                           ::assigned-location/assigned-location-id]))

(s/def ::assigned-locations
  (s/coll-of ::assigned-location :distinct true :into []))

(s/def ::google-audience ::google-audience/spec)

(s/def ::google-audiences
  (s/coll-of ::google-audience :distinct true :into []))

(s/def ::accessor
  (spec/only-keys :opt-un [::advertiser/advertiser-id
                           ::partner/partner-id]))
