(ns com.adgoji.displayvideo-api.advertisers.campaigns.assigned-targeting-options
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.campaigns-assigned-targeting-options.interface
    :as assigned-targeting-options]
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]))

(defn get-by-id
  "Returns a single assigned-targeting-option by `assigned-targeting-option-id`."
  [client advertiser-id campaign-id targeting-type assigned-targeting-option-id]
  (assigned-targeting-options/get-by-id client
                                        advertiser-id
                                        campaign-id
                                        targeting-type
                                        assigned-targeting-option-id))

(s/fdef get-by-id
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :campaign-id ::displayvideo-spec/campaign-id
               :targeting-type ::displayvideo-spec/campaign-targeting-type
               :assigned-targeting-option-id ::displayvideo-spec/assigned-targeting-option-id)
  :ret ::displayvideo-spec/assigned-targeting-option)

(defn get-list
  "Returns a list of all assigned targeting options of a campaign"
  [client advertiser-id campaign-id targeting-type opts]
  (assigned-targeting-options/get-list client
                                       advertiser-id
                                       campaign-id
                                       targeting-type
                                       opts))

(s/fdef get-list
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :campaign-id ::displayvideo-spec/campaign-id
               :targeting-type ::displayvideo-spec/campaign-targeting-type
               :opts (s/keys :opt-un [::displayvideo-spec/order-by
                                      ::displayvideo-spec/filter-expr
                                      ::displayvideo-spec/limit]))
  :ret ::displayvideo-spec/assigned-targeting-options)
