(ns com.adgoji.displayvideo-api.advertisers.assigned-locations
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.advertisers-assigned-locations.interface :as assigned-locations]
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]))

(defn create
  "Creates an assignment between a location and a location list."
  [client advertiser-id location-list-id assigned-location]
  (assigned-locations/create client advertiser-id location-list-id assigned-location))

(s/fdef create
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :location-list-id ::displayvideo-spec/location-list-id
               :assigned-location ::displayvideo-spec/assigned-location)
  :ret ::displayvideo-spec/assigned-location)

(defn delete
  "Deletes the assignment between a location and a location list."
  [client advertiser-id location-list-id assigned-location-id]
  (assigned-locations/delete client advertiser-id location-list-id assigned-location-id))

(s/fdef delete
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :location-list-id ::displayvideo-spec/location-list-id
               :assigned-location-id ::displayvideo-spec/assigned-location-id)
  :ret (s/and map? empty?))

(defn get-list
  "Lists locations assigned to a location list."
  [client advertiser-id location-list-id  opts]
  (assigned-locations/get-list client advertiser-id location-list-id opts))

(s/fdef get-list
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :location-list-id ::displayvideo-spec/location-list-id
               :opts (s/keys :opt-un [::displayvideo-spec/order-by
                                      ::displayvideo-spec/filter-expr
                                      ::displayvideo-spec/limit]))
  :ret ::displayvideo-spec/assigned-locations)

(defn bulk-edit
  "Bulk edits multiple assignments between locations and a single location list.
The operation will delete the assigned locations provided in
  deletedAssignedLocations and then create the assigned locations provided in
  createdAssignedLocations."
  [client advertiser-id location-list-id bulk-edit-request]
  (assigned-locations/bulk-edit client
                                advertiser-id
                                location-list-id
                                bulk-edit-request))

(s/fdef bulk-edit
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :location-list-id ::displayvideo-spec/location-list-id
               :bulk-edit-request ::displayvideo-spec/bulk-edit-assigned-locations-request)
  :ret ::displayvideo-spec/assigned-locations)
