(ns com.adgoji.displayvideo-spec.common
  (:require
   [clojure.spec.alpha :as s]))

(def ^:private email-regex #"^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,63}$")
(s/def ::email (s/and string? (partial re-matches email-regex)))
(s/def ::review-status
  #{"REVIEW_STATUS_UNSPECIFIED"
    "REVIEW_STATUS_APPROVED"
    "REVIEW_STATUS_REJECTED"
    "REVIEW_STATUS_PENDING"})

(s/def ::update-mask
  (s/coll-of keyword? :distinct true :into []))
