(ns com.adgoji.displayvideo-spec.displayvideo.bulk-edit-assigned-targeting-options-request
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.displayvideo.line-item :as line-item]
   [com.adgoji.displayvideo-spec.displayvideo.create-assigned-targeting-options-request :as create-assigned-targeting-options-request]
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.displayvideo-spec.displayvideo.delete-assigned-targeting-options-request :as delete-assigned-targeting-options-request]))

(s/def ::line-item-ids
  (s/coll-of ::line-item/line-item-id
             :distinct true
             :into []))

(s/def ::create-requests
  (s/coll-of ::create-assigned-targeting-options-request/spec
             :distinct true
             :into []))

(s/def ::delete-requests
  (s/coll-of ::delete-assigned-targeting-options-request/spec
             :distinct true
             :into []))

(s/def ::spec
  (spec/only-keys :req-un [::line-item-ids]
                  :opt-un [::create-requests
                           ::delete-requests]))
