(ns com.adgoji.displayvideo-spec.displayvideo.integral-ad-science
  (:require
   [clojure.spec.alpha :as s]))

(s/def ::traq-score-option
  #{"TRAQ_UNSPECIFIED"
    "TRAQ_250"
    "TRAQ_500"
    "TRAQ_600"
    "TRAQ_700"
    "TRAQ_750"
    "TRAQ_875"
    "TRAQ_1000"})

(s/def ::exclude-unrateable boolean?)

(s/def ::excluded-adult-risk
  #{"ADULT_UNSPECIFIED"
    "ADULT_HR"
    "ADULT_HMR"})

(s/def ::excluded-alcohol-risk
  #{"ALCOHOL_UNSPECIFIED"
    "ALCOHOL_HR"
    "ALCOHOL_HMR"})

(s/def ::excluded-illegal-downloads-risk
  #{"ILLEGAL_DOWNLOADS_UNSPECIFIED"
    "ILLEGAL_DOWNLOADS_HR"
    "ILLEGAL_DOWNLOADS_HMR"})

(s/def ::excluded-drugs-risk
  #{"DRUGS_UNSPECIFIED"
    "DRUGS_HR"
    "DRUGS_HMR"})

(s/def ::excluded-hate-speech-risk
  #{"HATE_SPEECH_UNSPECIFIED"
    "HATE_SPEECH_HR"
    "HATE_SPEECH_HMR"})

(s/def ::excluded-offensive-language-risk
  #{"OFFENSIVE_LANGUAGE_UNSPECIFIED"
    "OFFENSIVE_LANGUAGE_HR"
    "OFFENSIVE_LANGUAGE_HMR"})

(s/def ::excluded-violence-risk
  #{"VIOLENCE_UNSPECIFIED"
    "VIOLENCE_HR"
    "VIOLENCE_HMR"})

(s/def ::excluded-gambling-risk
  #{"GAMBLING_UNSPECIFIED"
    "GAMBLING_HR"
    "GAMBLING_HMR"})

(s/def ::excluded-ad-fraud-risk
  #{"SUSPICIOUS_ACTIVITY_UNSPECIFIED"
    "SUSPICIOUS_ACTIVITY_HR"
    "SUSPICIOUS_ACTIVITY_HMR"})

(s/def ::display-viewability
  #{"PERFORMANCE_VIEWABILITY_UNSPECIFIED"
    "PERFORMANCE_VIEWABILITY_40"
    "PERFORMANCE_VIEWABILITY_50"
    "PERFORMANCE_VIEWABILITY_60"
    "PERFORMANCE_VIEWABILITY_70"})

(s/def ::video-viewability
  #{"VIDEO_VIEWABILITY_UNSPECIFIED"
    "VIDEO_VIEWABILITY_40"
    "VIDEO_VIEWABILITY_50"
    "VIDEO_VIEWABILITY_60"
    "VIDEO_VIEWABILITY_70"})

(s/def ::custom-segment-id (s/coll-of int? :into []))
