(ns com.adgoji.campaigns.core
  (:require
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]
   [com.adgoji.java-utils.interface :as java-utils]
   [com.adgoji.sdk-client-utils.interface :as sdk-client-utils]
   [com.adgoji.spec.interface :as spec])
  (:import
   (com.google.api.services.displayvideo.v3 DisplayVideo DisplayVideo$Advertisers$Campaigns$List)
   (com.google.api.services.displayvideo.v3.model Campaign)))

(defn create
  [^DisplayVideo client advertiser-id campaign]
  (let [campaign-conformed (spec/check campaign ::displayvideo-spec/campaign)
        campaign-request   (java-utils/clj->java Campaign campaign-conformed)]
    (-> client
        (.advertisers)
        (.campaigns)
        (.create (long advertiser-id) campaign-request)
        (sdk-client-utils/execute-and-convert)
        (spec/check ::displayvideo-spec/campaign))))

(defn delete
  [^DisplayVideo client advertiser-id campaign-id]
  (-> client
      (.advertisers)
      (.campaigns)
      (.delete (long advertiser-id) (long campaign-id))
      (sdk-client-utils/execute-and-convert)))

(defn get-by-id
  [^DisplayVideo client advertiser-id campaign-id]
  (-> client
      (.advertisers)
      (.campaigns)
      (.get (long advertiser-id) (long campaign-id))
      (sdk-client-utils/execute-and-convert)
      (spec/check ::displayvideo-spec/campaign)))

(defn- fetch-creatives-page
  [^DisplayVideo$Advertisers$Campaigns$List request ^String next-page-token]
  (-> request
      (.setPageToken next-page-token)
      (sdk-client-utils/execute-and-convert)))

(defn get-list
  [^DisplayVideo client advertiser-id {:keys [order-by filter-expr limit]}]
  (let [request (-> client
                    (.advertisers)
                    (.campaigns)
                    (.list (long advertiser-id)))]
    (when order-by
      (.setOrderBy ^DisplayVideo$Advertisers$Campaigns$List request order-by))
    (when filter-expr
      (.setFilter ^DisplayVideo$Advertisers$Campaigns$List request filter-expr))
    (-> (sdk-client-utils/execute-and-convert-paginated
         (partial fetch-creatives-page request)
         :campaigns
         limit)
        (spec/check ::displayvideo-spec/campaigns))))

(defn update-by-id
  [^DisplayVideo client advertiser-id campaign-id campaign update-mask]
  (let [mask             (-> update-mask
                             (spec/check ::displayvideo-spec/update-mask)
                             sdk-client-utils/normalize-mask)
        campaign-request (java-utils/clj->java Campaign campaign)]
    (-> client
        (.advertisers)
        (.campaigns)
        (.patch (long advertiser-id) (long campaign-id) campaign-request)
        (.setUpdateMask mask)
        (sdk-client-utils/execute-and-convert)
        (spec/check ::displayvideo-spec/campaign))))
