(ns com.adgoji.displayvideo-spec.displayvideo.creative-config
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.displayvideo.inventory-source.display-creative-config :as inventory-source.display-creative-config]
   [com.adgoji.displayvideo-spec.displayvideo.inventory-source.video-creative-config :as inventory-source.video-creative-config]))

(s/def ::creative-type
  #{"CREATIVE_TYPE_STANDARD"
    "CREATIVE_TYPE_VIDEO"})
(s/def ::display-creative-config ::inventory-source.display-creative-config/spec)
(s/def ::video-creative-config ::inventory-source.video-creative-config/spec)

(defmulti spec :creative-type)

(defmethod spec "CREATIVE_TYPE_STANDARD"
  [_]
  (s/keys :req-un [::creative-type
                   ::display-creative-config]))

(defmethod spec "CREATIVE_TYPE_VIDEO"
  [_]
  (s/keys :req-un [::creative-type
                   ::video-creative-config]))

(s/def ::spec
  (s/multi-spec spec :creative-type))
