(ns com.adgoji.doubleclick-spec.doubleclick.data-range
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.doubleclick-spec.doubleclick.date :as date]
   [com.adgoji.spec.interface :as spec]))

(s/def ::range
  #{"RANGE_UNSPECIFIED"
    "CUSTOM_DATES"
    "CURRENT_DAY"
    "PREVIOUS_DAY"
    "WEEK_TO_DATE"
    "MONTH_TO_DATE"
    "QUARTER_TO_DATE"
    "YEAR_TO_DATE"
    "PREVIOUS_WEEK"
    "PREVIOUS_MONTH"
    "PREVIOUS_QUARTER"
    "PREVIOUS_YEAR"
    "LAST_7_DAYS"
    "LAST_30_DAYS"
    "LAST_90_DAYS"
    "LAST_365_DAYS"
    "ALL_TIME"
    "LAST_14_DAYS"
    "LAST_60_DAYS"})
(s/def ::custom-start-date ::date/spec)
(s/def ::custom-end-date ::date/spec)
(s/def ::spec
  (spec/only-keys :req-un [::range]
                  :opt-un [::custom-start-date
                           ::custom-end-date]))
