(ns com.adgoji.geocoding.core
  (:require
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.maps-spec.interface :as maps-spec]
   [com.adgoji.maps-utils.interface :as maps-utils])
  (:import
   (com.google.maps GeocodingApi)))

(defn geocode [context location]
  (let [response (.await (GeocodingApi/geocode context location))
        results  (into []
                       (map maps-utils/geocoding-result->map)
                       response)]
    (spec/check results ::maps-spec/geocoding-results)))
