(ns com.adgoji.maps-spec.interface
  [:require
   [com.adgoji.maps-spec.geocoding :as geocoding]
   [com.adgoji.maps-spec.context :as context]
   [com.adgoji.maps-spec.lat-lng :as lat-lng]
   [com.adgoji.maps-spec.timezone :as timezone]
   [clojure.spec.alpha :as s]])

;;; context
(s/def ::api-key ::context/api-key)
(s/def ::context-opts ::context/context-opts)
(s/def ::context ::context/context)

;;; geocoding
(s/def ::location ::geocoding/location)
(s/def ::geocoding-results (s/coll-of ::geocoding/geocoding-result
                                      :distinct :true
                                      :into []))

;;; timezones
(s/def ::lat-lng  ::lat-lng/spec)
(s/def ::timezone ::timezone/timezone)
