/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging;

import flex.messaging.util.PropertyStringResourceLoader;
import flex.messaging.util.ResourceLoader;
import java.util.Locale;

public class LocalizedException
extends RuntimeException {
    protected transient ResourceLoader resourceLoader;
    protected int number;
    protected String message;
    protected String details;
    protected Throwable rootCause;
    private static final long serialVersionUID = 7980539484335065853L;

    public LocalizedException() {
    }

    public LocalizedException(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public void setMessage(int number) {
        this.setMessage(number, null, null, null);
    }

    public void setMessage(int number, Locale locale) {
        this.setMessage(number, null, locale, null);
    }

    public void setMessage(int number, Object[] arguments) {
        this.setMessage(number, null, null, arguments);
    }

    public void setMessage(int number, String variant) {
        this.setMessage(number, variant, null, null);
    }

    public void setMessage(int number, String variant, Locale locale) {
        this.setMessage(number, variant, locale, null);
    }

    public void setMessage(int number, String variant, Object[] arguments) {
        this.setMessage(number, variant, null, arguments);
    }

    public void setMessage(int number, String variant, Locale locale, Object[] arguments) {
        this.setNumber(number);
        ResourceLoader resources = this.getResourceLoader();
        this.setMessage(resources.getString(this.generateFullKey(number, variant), locale, arguments));
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public int getNumber() {
        return this.number;
    }

    public void setDetails(int number) {
        this.setDetails(number, null, null, null);
    }

    public void setDetails(int number, String variant) {
        this.setDetails(number, variant, null, null);
    }

    public void setDetails(int number, String variant, Locale locale) {
        this.setDetails(number, variant, locale, null);
    }

    public void setDetails(int number, String variant, Object[] arguments) {
        this.setDetails(number, variant, null, arguments);
    }

    public void setDetails(int number, String variant, Locale locale, Object[] arguments) {
        this.setNumber(number);
        ResourceLoader resources = this.getResourceLoader();
        this.setDetails(resources.getString(this.generateDetailsKey(number, variant), locale, arguments));
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    public void setRootCause(Throwable cause) {
        this.rootCause = cause;
        this.initCause(cause);
    }

    protected ResourceLoader getResourceLoader() {
        if (this.resourceLoader == null) {
            this.resourceLoader = new PropertyStringResourceLoader();
        }
        return this.resourceLoader;
    }

    private String generateFullKey(int number, String variant) {
        return variant != null ? number + "-" + variant : String.valueOf(number);
    }

    private String generateDetailsKey(int number, String variant) {
        return this.generateFullKey(number, variant) + "-details";
    }

    public String toString() {
        String result = super.toString();
        if (this.details != null) {
            StringBuffer buffer = new StringBuffer(result);
            if (!result.endsWith(".")) {
                buffer.append(".");
            }
            buffer.append(' ').append(this.details);
            result = buffer.toString();
        }
        return result;
    }
}

