/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import flex.messaging.log.Log;
import flex.messaging.util.StringUtils;

public class ObjectTrace {
    public boolean nextElementExclude;
    protected StringBuffer buffer;
    protected int m_indent;
    protected int m_nested;
    public static String newLine = StringUtils.NEWLINE;

    public ObjectTrace() {
        this.buffer = new StringBuffer(4096);
    }

    public ObjectTrace(int bufferSize) {
        this.buffer = new StringBuffer(bufferSize);
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void write(Object o) {
        if (this.m_nested <= 0) {
            this.buffer.append(this.indentString());
        }
        this.buffer.append(String.valueOf(o));
    }

    public void writeNull() {
        if (this.m_nested <= 0) {
            this.buffer.append(this.indentString());
        }
        this.buffer.append("null");
    }

    public void writeRef(int ref) {
        if (this.m_nested <= 0) {
            this.buffer.append(this.indentString());
        }
        this.buffer.append("(Ref #").append(ref).append(")");
    }

    public void writeString(String s) {
        if (this.m_nested <= 0) {
            this.buffer.append(this.indentString());
        }
        this.buffer.append("\"").append(s).append("\"");
    }

    public void startArray(String header) {
        if (header != null && header.length() > 0) {
            if (this.m_nested <= 0) {
                this.buffer.append(this.indentString());
            }
            this.buffer.append(header).append(newLine);
        }
        ++this.m_indent;
        ++this.m_nested;
    }

    public void arrayElement(int index) {
        this.buffer.append(this.indentString()).append("[").append(index).append("] = ");
    }

    public void endArray() {
        --this.m_indent;
        --this.m_nested;
    }

    public void startObject(String header) {
        if (header != null && header.length() > 0) {
            if (this.m_nested <= 0) {
                this.buffer.append(this.indentString());
            }
            this.buffer.append(header).append(newLine);
        }
        ++this.m_indent;
        ++this.m_nested;
    }

    public void namedElement(String name) {
        if (Log.isExcludedProperty(name)) {
            this.nextElementExclude = true;
        }
        this.buffer.append(this.indentString()).append(name).append(" = ");
    }

    public void endObject() {
        --this.m_indent;
        --this.m_nested;
    }

    public void newLine() {
        boolean alreadyPadded = false;
        int length = this.buffer.length();
        if (length > 3) {
            String tail = this.buffer.substring(length - 3, length - 1);
            alreadyPadded = tail.equals(newLine);
        }
        if (!alreadyPadded) {
            this.buffer.append(newLine);
        }
    }

    protected String indentString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.m_indent; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }
}

