/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.client;

import flex.messaging.ConnectionAwareSession;
import flex.messaging.FlexContext;
import flex.messaging.FlexSession;
import flex.messaging.FlexSessionListener;
import flex.messaging.MessageClient;
import flex.messaging.MessageClientListener;
import flex.messaging.MessageException;
import flex.messaging.client.AsyncPollHandler;
import flex.messaging.client.EndpointPushHandler;
import flex.messaging.client.FlexClientAttributeListener;
import flex.messaging.client.FlexClientBindingEvent;
import flex.messaging.client.FlexClientBindingListener;
import flex.messaging.client.FlexClientListener;
import flex.messaging.client.FlexClientManager;
import flex.messaging.client.FlexClientNotSubscribedException;
import flex.messaging.client.FlexClientOutboundQueueProcessor;
import flex.messaging.client.FlushResult;
import flex.messaging.client.OutboundQueueThrottleManager;
import flex.messaging.client.PollFlushResult;
import flex.messaging.client.PollWaitListener;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.log.Log;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import flex.messaging.util.StringUtils;
import flex.messaging.util.TimeoutAbstractObject;
import flex.messaging.util.UUIDUtils;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexClient
extends TimeoutAbstractObject
implements FlexSessionListener,
MessageClientListener {
    public static final String FLEX_CLIENT_LOG_CATEGORY = "Client.FlexClient";
    public static final String NULL_FLEXCLIENT_ID = "nil";
    private static final int FLEX_CLIENT_INVALIDATED = 10027;
    private static final int ENDPOINT_PUSH_HANDLER_ALREADY_REGISTERED = 10033;
    private static final String POLL_WAIT_THREAD_NAME_EXTENSION = "-in-poll-wait";
    private static final CopyOnWriteArrayList<FlexClientListener> createdListeners = new CopyOnWriteArrayList();
    private volatile Map<String, Object> attributes;
    private volatile CopyOnWriteArrayList<FlexClientAttributeListener> attributeListeners;
    private volatile CopyOnWriteArrayList<FlexClientListener> destroyedListeners;
    final FlexClientManager flexClientManager;
    private final String id;
    volatile boolean invalidating;
    final Object lock = new Object();
    private volatile CopyOnWriteArrayList<MessageClient> messageClients;
    private final Map<String, EndpointQueue> outboundQueues = new ConcurrentHashMap<String, EndpointQueue>(1);
    private Map<String, EndpointPushHandler> endpointPushHandlers;
    private final CopyOnWriteArrayList<FlexSession> sessions = new CopyOnWriteArrayList();
    boolean valid;
    private Principal userPrincipal;

    public static void addClientCreatedListener(FlexClientListener listener) {
        if (listener != null) {
            createdListeners.addIfAbsent(listener);
        }
    }

    public static void removeClientCreatedListener(FlexClientListener listener) {
        if (listener != null) {
            createdListeners.remove(listener);
        }
    }

    public FlexClient(FlexClientManager manager) {
        this(manager, UUIDUtils.createUUID());
    }

    public FlexClient(FlexClientManager manager, String id) {
        this.id = id;
        this.flexClientManager = manager;
        this.updateLastUse();
        this.valid = true;
        if (Log.isDebug()) {
            Log.getLogger((String)FLEX_CLIENT_LOG_CATEGORY).debug("FlexClient created with id '" + this.id + "'.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientAttributeListener(FlexClientAttributeListener listener) {
        if (listener != null) {
            this.checkValid();
            if (this.attributeListeners == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.attributeListeners == null) {
                        this.attributeListeners = new CopyOnWriteArrayList();
                    }
                }
            }
            this.attributeListeners.addIfAbsent(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientDestroyedListener(FlexClientListener listener) {
        if (listener != null) {
            this.checkValid();
            if (this.destroyedListeners == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.destroyedListeners == null) {
                        this.destroyedListeners = new CopyOnWriteArrayList();
                    }
                }
            }
            this.destroyedListeners.addIfAbsent(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            this.updateLastUse();
            return this.attributes == null ? null : this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<String> getAttributeNames() {
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            this.updateLastUse();
            if (this.attributes == null) {
                return Collections.enumeration(Collections.emptyList());
            }
            return Collections.enumeration(new ArrayList<String>(this.attributes.keySet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointPushHandler getEndpointPushHandler(String endpointId) {
        Object object = this.lock;
        synchronized (object) {
            if (this.endpointPushHandlers != null && this.endpointPushHandlers.containsKey(endpointId)) {
                return this.endpointPushHandlers.get(endpointId);
            }
            return null;
        }
    }

    public FlexClientOutboundQueueProcessor getOutboundQueueProcessor(String endpointId) {
        EndpointQueue queue = this.outboundQueues.get(endpointId);
        return queue != null ? queue.processor : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastUse() {
        Object object = this.lock;
        synchronized (object) {
            long currentLastUse = super.getLastUse();
            long idleTime = System.currentTimeMillis() - currentLastUse;
            if (idleTime < this.flexClientManager.getFlexClientTimeoutMillis()) {
                return currentLastUse;
            }
            if (!this.outboundQueues.isEmpty()) {
                for (EndpointQueue queue : this.outboundQueues.values()) {
                    if (queue.asyncPoll != null) {
                        return System.currentTimeMillis();
                    }
                    if (this.endpointPushHandlers == null || !this.endpointPushHandlers.containsKey(queue.endpointId)) continue;
                    return System.currentTimeMillis();
                }
            }
            for (FlexSession session : this.sessions) {
                if (session instanceof ConnectionAwareSession && ((ConnectionAwareSession)((Object)session)).isConnected()) {
                    return System.currentTimeMillis();
                }
                if (session.waitMonitor == null) continue;
                for (EndpointQueue queue : session.waitMonitor.values()) {
                    if (!queue.flexClient.equals(this)) continue;
                    return System.currentTimeMillis();
                }
            }
            return currentLastUse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal getUserPrincipal() {
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            return this.userPrincipal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserPrincipal(Principal userPrincipal) {
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            this.userPrincipal = userPrincipal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.valid || this.invalidating) {
                return;
            }
            this.invalidating = true;
            this.flexClientManager.removeFlexClient(this);
            this.cancelTimeout();
        }
        if (!this.sessions.isEmpty()) {
            for (FlexSession session : this.sessions) {
                this.unregisterFlexSession(session);
            }
        }
        if (this.messageClients != null && !this.messageClients.isEmpty()) {
            for (MessageClient messageClient : this.messageClients) {
                messageClient.removeMessageClientDestroyedListener(this);
                messageClient.invalidate();
            }
            this.messageClients.clear();
        }
        if (this.destroyedListeners != null && !this.destroyedListeners.isEmpty()) {
            for (FlexClientListener destroyListener : this.destroyedListeners) {
                destroyListener.clientDestroyed(this);
            }
            this.destroyedListeners.clear();
        }
        if (this.attributes != null && !this.attributes.isEmpty()) {
            String[] keys;
            Set<String> keySet = this.attributes.keySet();
            for (String key : keys = keySet.toArray(new String[keySet.size()])) {
                this.removeAttribute(key);
            }
        }
        if (this.endpointPushHandlers != null && !this.endpointPushHandlers.isEmpty()) {
            for (EndpointPushHandler handler : this.endpointPushHandlers.values()) {
                handler.close(true);
            }
            this.endpointPushHandlers = null;
        }
        object = this.lock;
        synchronized (object) {
            this.valid = false;
            this.invalidating = false;
        }
        if (Log.isDebug()) {
            Log.getLogger((String)FLEX_CLIENT_LOG_CATEGORY).debug("FlexClient with id '" + this.id + "' has been invalidated.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Object object = this.lock;
        synchronized (object) {
            return this.valid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FlexSession> getFlexSessions() {
        ArrayList<FlexSession> currentSessions;
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            this.updateLastUse();
            currentSessions = new ArrayList<FlexSession>(this.sessions);
        }
        return currentSessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSessionCount() {
        int sessionCount;
        Object object = this.lock;
        synchronized (object) {
            sessionCount = this.sessions != null ? this.sessions.size() : 0;
        }
        return sessionCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSubscriptionCount() {
        int count = 0;
        Object object = this.lock;
        synchronized (object) {
            if (this.messageClients != null && !this.messageClients.isEmpty()) {
                for (MessageClient messageClient : this.messageClients) {
                    count += messageClient.getSubscriptionCount();
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageClient getMessageClient(String clientId) {
        Object object = this.lock;
        synchronized (object) {
            if (this.messageClients != null && !this.messageClients.isEmpty()) {
                for (MessageClient messageClient : this.messageClients) {
                    if (!messageClient.getClientId().equals(clientId)) continue;
                    return messageClient;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MessageClient> getMessageClients() {
        ArrayList<MessageClient> currentMessageClients;
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            this.updateLastUse();
            currentMessageClients = this.messageClients != null ? new ArrayList<MessageClient>(this.messageClients) : Collections.emptyList();
        }
        return currentMessageClients;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public long getTimeoutPeriod() {
        return this.flexClientManager.getFlexClientTimeoutMillis();
    }

    @Override
    public void messageClientCreated(MessageClient messageClient) {
    }

    @Override
    public void messageClientDestroyed(MessageClient messageClient) {
        this.unregisterMessageClient(messageClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlushResult poll(String endpointId) {
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            EndpointQueue queue = this.outboundQueues.get(endpointId);
            if (queue != null) {
                return this.internalPoll(queue);
            }
            this.throwNotSubscribedException(endpointId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TimeoutAbstractObject pollAsync(String endpointId, AsyncPollHandler handler, long waitIntervalMillis) {
        AsyncPollWithTimeout asyncPollTask = null;
        Object object = this.lock;
        synchronized (object) {
            block13: {
                this.checkValid();
                EndpointQueue queue = this.outboundQueues.get(endpointId);
                if (queue != null) {
                    if (!queue.messages.isEmpty()) {
                        handler.asyncPollComplete(this.internalFlush(queue));
                        break block13;
                    } else {
                        FlexSession session;
                        FlexSession flexSession = session = FlexContext.getFlexSession();
                        synchronized (flexSession) {
                            AsyncPollWithTimeout parkedPoll;
                            if (session.asyncPollMap != null && (parkedPoll = session.asyncPollMap.get(endpointId)) != null) {
                                PollFlushResult result;
                                if (parkedPoll.getFlexClient().equals(this)) {
                                    result = new PollFlushResult();
                                    result.setClientProcessingSuppressed(true);
                                    handler.asyncPollComplete(result);
                                } else {
                                    result = new PollFlushResult();
                                    result.setAvoidBusyPolling(true);
                                    this.completeAsyncPoll(parkedPoll, result);
                                }
                            }
                            AsyncPollWithTimeout asyncPoll = new AsyncPollWithTimeout(this, session, queue, handler, waitIntervalMillis, endpointId);
                            FlexSession flexSession2 = session;
                            synchronized (flexSession2) {
                                if (session.asyncPollMap == null) {
                                    session.asyncPollMap = new HashMap();
                                }
                                session.asyncPollMap.put(endpointId, asyncPoll);
                            }
                            queue.asyncPoll = asyncPoll;
                            return asyncPoll;
                        }
                    }
                }
                this.throwNotSubscribedException(endpointId);
            }
            return asyncPollTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FlushResult pollWithWait(String endpointId, FlexSession session, PollWaitListener listener, long waitIntervalMillis) {
        EndpointQueue queue;
        Object object = this.lock;
        synchronized (object) {
            FlushResult flushResult;
            this.checkValid();
            queue = this.outboundQueues.get(endpointId);
            if (queue != null && (flushResult = this.internalPoll(queue)) != null) {
                return flushResult;
            }
        }
        if (queue != null) {
            object = session;
            synchronized (object) {
                if (session.waitMonitor != null) {
                    EndpointQueue waitingQueue = session.waitMonitor.get(endpointId);
                    if (waitingQueue != null && waitingQueue.flexClient.equals(this)) {
                        PollFlushResult result = new PollFlushResult();
                        result.setClientProcessingSuppressed(true);
                        return result;
                    }
                } else {
                    session.waitMonitor = new HashMap();
                }
                session.waitMonitor.put(endpointId, queue);
            }
            waitIntervalMillis = waitIntervalMillis == -1L ? 0L : waitIntervalMillis;
            String threadName = Thread.currentThread().getName();
            try {
                FlushResult result;
                Object currentThread;
                boolean didWait = false;
                boolean avoidBusyPolling = false;
                Object object2 = queue;
                synchronized (object2) {
                    if (queue.messages.isEmpty()) {
                        if (Log.isDebug()) {
                            Log.getLogger((String)FLEX_CLIENT_LOG_CATEGORY).debug("Poll wait thread '" + threadName + "' for FlexClient with id '" + this.id + "' is waiting for new messages to arrive.");
                        }
                        didWait = true;
                        currentThread = Thread.currentThread();
                        ((Thread)currentThread).setName(threadName + POLL_WAIT_THREAD_NAME_EXTENSION);
                        if (listener != null) {
                            listener.waitStart(queue);
                        }
                        queue.waitPoll = true;
                        queue.wait(waitIntervalMillis);
                        queue.waitPoll = false;
                        ((Thread)currentThread).setName(threadName);
                        if (listener != null) {
                            listener.waitEnd(queue);
                        }
                        if (queue.avoidBusyPolling) {
                            avoidBusyPolling = true;
                            queue.avoidBusyPolling = false;
                        }
                    }
                }
                object2 = session;
                synchronized (object2) {
                    if (session.waitMonitor != null) {
                        session.waitMonitor.remove(endpointId);
                    }
                }
                if (Log.isDebug()) {
                    if (didWait) {
                        Log.getLogger((String)FLEX_CLIENT_LOG_CATEGORY).debug("Poll wait thread '" + threadName + "' for FlexClient with id '" + this.id + "' is done waiting for new messages to arrive and is flushing the outbound queue.");
                    } else {
                        Log.getLogger((String)FLEX_CLIENT_LOG_CATEGORY).debug("Poll wait thread '" + threadName + "' for FlexClient with id '" + this.id + "' didn't need to wait and is flushing the outbound queue.");
                    }
                }
                currentThread = this.lock;
                synchronized (currentThread) {
                    result = this.internalFlush(queue);
                }
                if (!avoidBusyPolling) return result;
                PollFlushResult swappedPollResult = new PollFlushResult();
                if (result != null) {
                    swappedPollResult.setMessages(result.getMessages());
                    swappedPollResult.setNextFlushWaitTimeMillis(result.getNextFlushWaitTimeMillis());
                }
                swappedPollResult.setAvoidBusyPolling(true);
                return swappedPollResult;
            }
            catch (InterruptedException e) {
                if (!Log.isWarn()) return null;
                Log.getLogger((String)FLEX_CLIENT_LOG_CATEGORY).warn("Poll wait thread '" + threadName + "' for FlexClient with id '" + this.id + "' could not finish waiting for new messages to arrive " + "because it was interrupted: " + e.toString());
                return null;
            }
        }
        this.throwNotSubscribedException(endpointId);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlushResult poll(MessageClient client) {
        FlushResult flushResult = null;
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            String endpointId = client.getEndpointId();
            EndpointQueue queue = this.outboundQueues.get(endpointId);
            if (queue != null) {
                try {
                    flushResult = this.internalFlush(queue, client);
                }
                catch (RuntimeException e) {
                    if (Log.isError()) {
                        Log.getLogger((String)FLEX_CLIENT_LOG_CATEGORY).error("Failed to flush an outbound queue for MessageClient '" + client.getClientId() + "' for FlexClient '" + this.getId() + "'.", (Throwable)e);
                    }
                    throw e;
                }
                if (flushResult != null) {
                    flushResult.setNextFlushWaitTimeMillis(0);
                }
            } else {
                this.throwNotSubscribedException(endpointId);
            }
        }
        return flushResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Message message, MessageClient messageClient) {
        boolean empty;
        if (!this.isValid()) {
            return;
        }
        this.updateLastUse();
        EndpointQueue queue = this.outboundQueues.get(messageClient.getEndpointId());
        if (queue == null) {
            return;
        }
        EndpointQueue endpointQueue = queue;
        synchronized (endpointQueue) {
            try {
                queue.processor.add(queue.messages, message);
                empty = queue.messages.isEmpty();
                if (Log.isDebug()) {
                    Log.getLogger((String)"Message.General").debug("Queuing message: " + message.getMessageId() + StringUtils.NEWLINE + "  to send to MessageClient: " + messageClient.getClientId() + StringUtils.NEWLINE + "  for FlexClient: " + messageClient.getFlexClient().getId() + StringUtils.NEWLINE + "  via endpoint: " + queue.endpointId + StringUtils.NEWLINE + "  client outbound queue size: " + queue.messages.size());
                }
            }
            catch (RuntimeException e) {
                if (Log.isError()) {
                    Log.getLogger((String)FLEX_CLIENT_LOG_CATEGORY).error("Failed to add a message to an outbound queue for FlexClient '" + this.getId() + "'.", (Throwable)e);
                }
                throw e;
            }
            if (!empty && queue.waitPoll) {
                queue.notifyAll();
            }
        }
        if (!empty) {
            if (queue.asyncPoll != null) {
                this.completeAsyncPoll(queue.asyncPoll, this.internalFlush(queue));
            } else if (!empty && queue.flushTask == null && (queue.pushSession != null || this.endpointPushHandlers != null && this.endpointPushHandlers.containsKey(queue.endpointId))) {
                this.directFlush(queue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEndpointPushHandler(EndpointPushHandler handler, String endpointId) {
        Object object = this.lock;
        synchronized (object) {
            if (this.endpointPushHandlers == null) {
                this.endpointPushHandlers = new HashMap<String, EndpointPushHandler>(1);
            }
            if (this.endpointPushHandlers.containsKey(endpointId)) {
                MessageException me = new MessageException();
                me.setMessage(10033, new Object[]{this.getId(), endpointId});
                throw me;
            }
            this.endpointPushHandlers.put(endpointId, handler);
        }
    }

    public void registerFlexSession(FlexSession session) {
        if (this.sessions.addIfAbsent(session)) {
            session.addSessionDestroyedListener(this);
            session.registerFlexClient(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessageClient(MessageClient messageClient) {
        if (this.messageClients == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.messageClients == null) {
                    this.messageClients = new CopyOnWriteArrayList();
                }
            }
        }
        if (this.messageClients.addIfAbsent(messageClient)) {
            messageClient.addMessageClientDestroyedListener(this);
            String endpointId = messageClient.getEndpointId();
            Object object = this.lock;
            synchronized (object) {
                EndpointPushHandler handler;
                this.getOrCreateEndpointQueueAndRegisterSubscription(messageClient, endpointId);
                if (this.endpointPushHandlers != null && (handler = this.endpointPushHandlers.get(endpointId)) != null) {
                    handler.registerMessageClient(messageClient);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        Object value;
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            this.updateLastUse();
            value = this.attributes != null ? this.attributes.remove(name) : null;
        }
        if (value == null) {
            return;
        }
        this.notifyAttributeUnbound(name, value);
        this.notifyAttributeRemoved(name, value);
    }

    public void removeClientAttributeListener(FlexClientAttributeListener listener) {
        if (listener != null && this.attributeListeners != null) {
            this.attributeListeners.remove(listener);
        }
    }

    public void removeClientDestroyedListener(FlexClientListener listener) {
        if (listener != null && this.destroyedListeners != null) {
            this.destroyedListeners.remove(listener);
        }
    }

    @Override
    public void sessionCreated(FlexSession session) {
    }

    @Override
    public void sessionDestroyed(FlexSession session) {
        this.unregisterFlexSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        Object oldValue;
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            this.updateLastUse();
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>();
            }
            oldValue = this.attributes.put(name, value);
        }
        if (oldValue == null) {
            this.notifyAttributeBound(name, value);
            this.notifyAttributeAdded(name, value);
        } else {
            this.notifyAttributeUnbound(name, oldValue);
            this.notifyAttributeReplaced(name, oldValue);
            this.notifyAttributeBound(name, value);
        }
    }

    @Override
    public void timeout() {
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEndpointPushHandler(EndpointPushHandler handler, String endpointId) {
        Object object = this.lock;
        synchronized (object) {
            if (this.endpointPushHandlers == null) {
                return;
            }
            if (this.endpointPushHandlers.get(endpointId).equals(handler)) {
                this.endpointPushHandlers.remove(endpointId);
            }
        }
    }

    public void unregisterFlexSession(FlexSession session) {
        if (this.sessions.remove(session)) {
            session.removeSessionDestroyedListener(this);
            session.unregisterFlexClient(this);
            if (this.sessions.isEmpty()) {
                this.invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMessageClient(MessageClient messageClient) {
        if (this.messageClients != null && this.messageClients.remove(messageClient)) {
            messageClient.removeMessageClientDestroyedListener(this);
            String endpointId = messageClient.getEndpointId();
            Object object = this.lock;
            synchronized (object) {
                EndpointPushHandler handler;
                EndpointQueue queue = this.outboundQueues.get(endpointId);
                if (queue != null) {
                    --queue.messageClientRefCount;
                    OutboundQueueThrottleManager tm = queue.processor.getOutboundQueueThrottleManager();
                    if (tm != null) {
                        tm.unregisterAllSubscriptions(messageClient.getDestinationId());
                    }
                    if (!messageClient.isAttemptingInvalidationClientNotification()) {
                        Object messageClientId = messageClient.getClientId();
                        Iterator<Message> iter = queue.messages.iterator();
                        while (iter.hasNext()) {
                            Message message = iter.next();
                            if (!message.getClientId().equals(messageClientId)) continue;
                            iter.remove();
                        }
                    }
                    if (queue.messageClientRefCount == 0 && (queue.messages.isEmpty() || messageClient.isClientChannelDisconnected())) {
                        if (queue.asyncPoll != null) {
                            FlushResult flushResult = this.internalFlush(queue);
                            if (!messageClient.isAttemptingInvalidationClientNotification()) {
                                CommandMessage msg = new CommandMessage();
                                msg.setClientId(messageClient.getClientId());
                                msg.setOperation(10);
                                List<Message> messages = flushResult.getMessages();
                                if (messages == null) {
                                    messages = new ArrayList<Message>(1);
                                }
                                messages.add(msg);
                            }
                            this.completeAsyncPoll(queue.asyncPoll, flushResult);
                        }
                        this.outboundQueues.remove(endpointId);
                    }
                    EndpointQueue endpointQueue = queue;
                    synchronized (endpointQueue) {
                        queue.notifyAll();
                    }
                }
                if (this.endpointPushHandlers != null && (handler = this.endpointPushHandlers.get(endpointId)) != null) {
                    handler.unregisterMessageClient(messageClient);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkValid() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.valid) {
                MessageException e = new MessageException();
                e.setMessage(10027);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeAsyncPoll(AsyncPollWithTimeout asyncPoll, FlushResult result) {
        Object object = this.lock;
        synchronized (object) {
            FlexSession session;
            asyncPoll.cancelTimeout();
            EndpointQueue queue = asyncPoll.getEndpointQueue();
            if (queue.asyncPoll.equals(asyncPoll)) {
                queue.asyncPoll = null;
            }
            FlexSession flexSession = session = asyncPoll.getFlexSession();
            synchronized (flexSession) {
                if (session.asyncPollMap != null) {
                    session.asyncPollMap.remove(asyncPoll.getEndpointId());
                }
            }
            asyncPoll.getHandler().asyncPollComplete(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void directFlush(EndpointQueue queue) {
        Object object = this.lock;
        synchronized (object) {
            int flushWaitTime;
            FlushResult flushResult;
            if (!this.valid) {
                return;
            }
            if (queue.flushTask != null) {
                queue.flushTask = null;
            }
            if ((flushResult = this.internalFlush(queue)) == null) {
                return;
            }
            List<Message> messages = flushResult.getMessages();
            if (messages != null && !messages.isEmpty()) {
                this.updateLastUse();
                if (queue.pushSession != null) {
                    for (Message msg : messages) {
                        queue.pushSession.push(msg);
                    }
                } else if (this.endpointPushHandlers != null) {
                    EndpointPushHandler handler = this.endpointPushHandlers.get(queue.endpointId);
                    handler.pushMessages(messages);
                }
            }
            if ((flushWaitTime = flushResult.getNextFlushWaitTimeMillis()) > 0) {
                queue.flushTask = new FlexClientScheduledFlushForPush(queue, flushWaitTime);
            }
        }
    }

    protected EndpointQueue getOrCreateEndpointQueueAndRegisterSubscription(MessageClient messageClient, String endpointId) {
        EndpointQueue newQueue;
        if (!this.outboundQueues.containsKey(endpointId)) {
            newQueue = new EndpointQueue();
            newQueue.flexClient = this;
            newQueue.endpointId = endpointId;
            newQueue.endpoint = this.flexClientManager.getMessageBroker().getEndpoint(endpointId);
            newQueue.messages = new ArrayList<Message>();
            FlexSession session = messageClient.getFlexSession();
            if (session.isPushSupported()) {
                newQueue.pushSession = session;
            }
            newQueue.processor = this.flexClientManager.createOutboundQueueProcessor(this, endpointId);
            newQueue.messageClientRefCount = 1;
            this.outboundQueues.put(endpointId, newQueue);
        } else {
            newQueue = this.outboundQueues.get(endpointId);
            ++newQueue.messageClientRefCount;
            FlexSession session = messageClient.getFlexSession();
            if (session.isPushSupported()) {
                newQueue.pushSession = session;
            }
        }
        return newQueue;
    }

    protected FlushResult internalFlush(EndpointQueue queue) {
        return this.internalFlush(queue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FlushResult internalFlush(EndpointQueue queue, MessageClient client) {
        FlushResult flushResult;
        try {
            List<Message> messages;
            EndpointQueue endpointQueue = queue;
            synchronized (endpointQueue) {
                flushResult = queue.processor.flush(client, queue.messages);
                this.shutdownQueue(queue);
            }
            List<Message> list = messages = flushResult != null ? flushResult.getMessages() : null;
            if (messages != null && !messages.isEmpty()) {
                this.updateLastUse();
            }
        }
        catch (RuntimeException e) {
            if (Log.isError()) {
                Log.getLogger((String)FLEX_CLIENT_LOG_CATEGORY).error("Failed to flush an outbound queue for FlexClient '" + this.getId() + "'.", (Throwable)e);
            }
            throw e;
        }
        return flushResult;
    }

    protected FlushResult internalPoll(EndpointQueue queue) {
        int flushWaitTime;
        FlushResult internalFlushResult;
        List<Message> flushedMessages;
        ArrayList<Message> allMessages = new ArrayList<Message>();
        if (queue.flushedMessagesBetweenPolls != null && queue.flushedMessagesBetweenPolls.size() > 0) {
            allMessages.addAll(queue.flushedMessagesBetweenPolls);
            queue.flushedMessagesBetweenPolls.clear();
        }
        if ((flushedMessages = (internalFlushResult = this.internalFlush(queue)).getMessages()) != null && !flushedMessages.isEmpty()) {
            allMessages.addAll(flushedMessages);
        }
        if ((flushWaitTime = internalFlushResult.getNextFlushWaitTimeMillis()) > 0) {
            queue.flushTask = new FlexClientScheduledFlushForPoll(queue, flushWaitTime);
        }
        if (allMessages.size() > 0) {
            FlushResult flushResult = new FlushResult();
            flushResult.setMessages(allMessages);
            return flushResult;
        }
        return null;
    }

    protected void notifyAttributeAdded(String name, Object value) {
        if (this.attributeListeners != null && !this.attributeListeners.isEmpty()) {
            FlexClientBindingEvent event = new FlexClientBindingEvent(this, name, value);
            for (FlexClientAttributeListener attribListener : this.attributeListeners) {
                attribListener.attributeAdded(event);
            }
        }
    }

    protected void notifyAttributeBound(String name, Object value) {
        if (value != null && value instanceof FlexClientBindingListener) {
            FlexClientBindingEvent bindingEvent = new FlexClientBindingEvent(this, name);
            ((FlexClientBindingListener)value).valueBound(bindingEvent);
        }
    }

    protected void notifyAttributeRemoved(String name, Object value) {
        if (this.attributeListeners != null && !this.attributeListeners.isEmpty()) {
            FlexClientBindingEvent event = new FlexClientBindingEvent(this, name, value);
            for (FlexClientAttributeListener attribListener : this.attributeListeners) {
                attribListener.attributeRemoved(event);
            }
        }
    }

    protected void notifyAttributeReplaced(String name, Object value) {
        if (this.attributeListeners != null && !this.attributeListeners.isEmpty()) {
            FlexClientBindingEvent event = new FlexClientBindingEvent(this, name, value);
            for (FlexClientAttributeListener attribListener : this.attributeListeners) {
                attribListener.attributeReplaced(event);
            }
        }
    }

    protected void notifyAttributeUnbound(String name, Object value) {
        if (value != null && value instanceof FlexClientBindingListener) {
            FlexClientBindingEvent bindingEvent = new FlexClientBindingEvent(this, name);
            ((FlexClientBindingListener)value).valueUnbound(bindingEvent);
        }
    }

    protected void notifyCreated() {
        if (!createdListeners.isEmpty()) {
            for (FlexClientListener createListener : createdListeners) {
                createListener.clientCreated(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean shutdownQueue(EndpointQueue queue) {
        if (queue.messageClientRefCount == 0 && queue.messages.isEmpty()) {
            this.outboundQueues.remove(queue.endpointId);
            EndpointQueue endpointQueue = queue;
            synchronized (endpointQueue) {
                queue.notifyAll();
            }
            return true;
        }
        return false;
    }

    protected void throwNotSubscribedException(String endpointId) {
        List<FlexClient> flexClients = FlexContext.getFlexSession().getFlexClients();
        for (FlexClient otherClient : flexClients) {
            if (otherClient.equals(this)) continue;
            List<MessageClient> otherSubs = otherClient.getMessageClients();
            for (MessageClient otherSub : otherSubs) {
                if (!otherSub.getEndpointId().equals(endpointId)) continue;
                FlexClientNotSubscribedException e = new FlexClientNotSubscribedException();
                e.setMessage(10036, new Object[]{endpointId});
                e.setCode("Server.Processing.NotSubscribed");
                throw e;
            }
        }
        FlexClientNotSubscribedException e = new FlexClientNotSubscribedException();
        e.setMessage(10028, new Object[]{endpointId});
        e.setCode("Server.Processing.NotSubscribed");
        throw e;
    }

    public static class EndpointQueue {
        public FlexClient flexClient;
        public String endpointId;
        public Endpoint endpoint;
        public List<Message> messages;
        public List<Message> flushedMessagesBetweenPolls;
        public FlexClientOutboundQueueProcessor processor;
        public AsyncPollWithTimeout asyncPoll;
        public boolean waitPoll;
        public FlexSession pushSession;
        public TimeoutAbstractObject flushTask;
        public int messageClientRefCount;
        public boolean avoidBusyPolling;
    }

    class FlexClientScheduledFlushForPoll
    extends FlexClientScheduledFlush {
        public FlexClientScheduledFlushForPoll(EndpointQueue queue, long waitIntervalMillis) {
            super(queue, waitIntervalMillis);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void performFlushTask() {
            Object object = FlexClient.this.lock;
            synchronized (object) {
                int flushWaitTime;
                FlushResult flushResult;
                if (!FlexClient.this.valid) {
                    return;
                }
                if (this.queue.flushTask != null) {
                    this.queue.flushTask = null;
                }
                if ((flushResult = FlexClient.this.internalFlush(this.queue)) == null) {
                    return;
                }
                List<Message> messages = flushResult.getMessages();
                if (messages != null && messages.size() > 0) {
                    if (this.queue.asyncPoll != null) {
                        FlexClient.this.completeAsyncPoll(this.queue.asyncPoll, flushResult);
                    } else {
                        if (this.queue.flushedMessagesBetweenPolls == null) {
                            this.queue.flushedMessagesBetweenPolls = new ArrayList<Message>();
                        }
                        this.queue.flushedMessagesBetweenPolls.addAll(messages);
                    }
                }
                if ((flushWaitTime = flushResult.getNextFlushWaitTimeMillis()) > 0) {
                    this.queue.flushTask = new FlexClientScheduledFlushForPoll(this.queue, flushWaitTime);
                }
            }
        }
    }

    class FlexClientScheduledFlushForPush
    extends FlexClientScheduledFlush {
        public FlexClientScheduledFlushForPush(EndpointQueue queue, long waitIntervalMillis) {
            super(queue, waitIntervalMillis);
        }

        void performFlushTask() {
            FlexClient.this.directFlush(this.queue);
        }
    }

    abstract class FlexClientScheduledFlush
    extends TimeoutAbstractObject {
        final EndpointQueue queue;

        public FlexClientScheduledFlush(EndpointQueue queue, long waitIntervalMillis) {
            this.queue = queue;
            this.setTimeoutPeriod(waitIntervalMillis);
            FlexClient.this.flexClientManager.monitorScheduledFlush(this);
        }

        abstract void performFlushTask();

        public void timeout() {
            FlexContext.setThreadLocalFlexClient(FlexClient.this);
            this.performFlushTask();
            FlexContext.setThreadLocalFlexClient(null);
        }
    }

    public class AsyncPollWithTimeout
    extends TimeoutAbstractObject {
        private final FlexClient flexClient;
        private final FlexSession session;
        private final EndpointQueue queue;
        private final AsyncPollHandler handler;
        private final String endpointId;

        public AsyncPollWithTimeout(FlexClient flexClient2, FlexSession session, EndpointQueue queue, AsyncPollHandler handler, long waitIntervalMillis, String endpointId) {
            this.flexClient = flexClient2;
            this.session = session;
            this.queue = queue;
            this.handler = handler;
            this.setTimeoutPeriod(waitIntervalMillis);
            FlexClient.this.flexClientManager.monitorAsyncPollTimeout(this);
            this.endpointId = endpointId;
        }

        public FlexClient getFlexClient() {
            return this.flexClient;
        }

        public FlexSession getFlexSession() {
            return this.session;
        }

        public EndpointQueue getEndpointQueue() {
            return this.queue;
        }

        public AsyncPollHandler getHandler() {
            return this.handler;
        }

        public String getEndpointId() {
            return this.endpointId;
        }

        public void timeout() {
            FlexClient.this.completeAsyncPoll(this, null);
        }
    }
}

