/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.client;

public class UserAgentSettings {
    public static final String USER_AGENT_CHROME = "Chrome";
    public static final String USER_AGENT_FIREFOX = "Firefox";
    public static final String USER_AGENT_FIREFOX_3 = "Firefox/3";
    public static final String USER_AGENT_MSIE = "MSIE";
    public static final String USER_AGENT_MSIE_8 = "MSIE 8";
    public static final String USER_AGENT_OPERA = "Opera";
    public static final String USER_AGENT_OPERA_8 = "Opera 8";
    public static final String USER_AGENT_OPERA_10 = "Opera/9.8";
    public static final String USER_AGENT_SAFARI = "Safari";
    public static final int KICKSTART_BYTES_MSIE = 2048;
    public static final int KICKSTART_BYTES_SAFARI = 512;
    public static final int MAX_PERSISTENT_CONNECTIONS_DEFAULT = 1;
    private static final int MAX_PERSISTENT_CONNECTIONS_CHROME = 5;
    private static final int MAX_PERSISTENT_CONNECTIONS_FIREFOX_3 = 5;
    private static final int MAX_PERSISTENT_CONNECTIONS_MSIE_8 = 5;
    private static final int MAX_PERSISTENT_CONNECTIONS_OPERA = 3;
    private static final int MAX_PERSISTENT_CONNECTIONS_OPERA_8 = 7;
    private static final int MAX_PERSISTENT_CONNECTIONS_OPERA_10 = 7;
    private static final int MAX_PERSISTENT_CONNECTIONS_SAFARI = 3;
    private String matchOn;
    private int kickstartBytes;
    private int maxPersistentConnectionsPerSession = 1;

    public static UserAgentSettings getAgent(String matchOn) {
        UserAgentSettings userAgent = new UserAgentSettings();
        userAgent.setMatchOn(matchOn);
        if (USER_AGENT_CHROME.equals(matchOn)) {
            userAgent.setMaxPersistentConnectionsPerSession(5);
        } else if (USER_AGENT_FIREFOX.equals(matchOn)) {
            userAgent.setMaxPersistentConnectionsPerSession(1);
        } else if (USER_AGENT_FIREFOX_3.equals(matchOn)) {
            userAgent.setMaxPersistentConnectionsPerSession(5);
        } else if (USER_AGENT_MSIE.equals(matchOn)) {
            userAgent.setKickstartBytes(2048);
            userAgent.setMaxPersistentConnectionsPerSession(1);
        } else if (USER_AGENT_MSIE_8.equals(matchOn)) {
            userAgent.setKickstartBytes(2048);
            userAgent.setMaxPersistentConnectionsPerSession(5);
        } else if (USER_AGENT_OPERA.equals(matchOn)) {
            userAgent.setMaxPersistentConnectionsPerSession(3);
        } else if (USER_AGENT_OPERA_8.equals(matchOn)) {
            userAgent.setMaxPersistentConnectionsPerSession(7);
        } else if (USER_AGENT_OPERA_10.equals(matchOn)) {
            userAgent.setMaxPersistentConnectionsPerSession(7);
        } else if (USER_AGENT_SAFARI.equals(matchOn)) {
            userAgent.setKickstartBytes(512);
            userAgent.setMaxPersistentConnectionsPerSession(3);
        }
        return userAgent;
    }

    public String getMatchOn() {
        return this.matchOn;
    }

    public void setMatchOn(String matchOn) {
        this.matchOn = matchOn;
    }

    public int getKickstartBytes() {
        return this.kickstartBytes;
    }

    public void setKickstartBytes(int kickstartBytes) {
        if (kickstartBytes < 0) {
            kickstartBytes = 0;
        }
        this.kickstartBytes = kickstartBytes;
    }

    public int getMaxStreamingConnectionsPerSession() {
        return this.getMaxPersistentConnectionsPerSession();
    }

    public void setMaxStreamingConnectionsPerSession(int maxStreamingConnectionsPerSession) {
        this.setMaxPersistentConnectionsPerSession(maxStreamingConnectionsPerSession);
    }

    public int getMaxPersistentConnectionsPerSession() {
        return this.maxPersistentConnectionsPerSession;
    }

    public void setMaxPersistentConnectionsPerSession(int maxStreamingConnectionsPerSession) {
        this.maxPersistentConnectionsPerSession = maxStreamingConnectionsPerSession;
    }
}

