/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.factories;

import flex.messaging.DestructibleFlexFactory;
import flex.messaging.FactoryInstance;
import flex.messaging.FlexContext;
import flex.messaging.FlexFactory;
import flex.messaging.FlexSession;
import flex.messaging.FlexSessionListener;
import flex.messaging.MessageBroker;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.factories.JavaFactoryInstance;
import flex.messaging.log.Log;
import flex.messaging.services.ServiceException;
import flex.messaging.util.ExceptionUtil;
import flex.messaging.util.StringUtils;
import javax.servlet.ServletContext;

public class JavaFactory
implements FlexFactory,
DestructibleFlexFactory {
    private static final String ATTRIBUTE_ID = "attribute-id";
    private static final int SINGLETON_ERROR = 10656;
    private static final int SESSION_NOT_FOUND = 10652;
    private static final int INVALID_CLASS_FOUND = 10654;

    public void initialize(String id, ConfigMap configMap) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FactoryInstance createFactoryInstance(String id, ConfigMap properties) {
        JavaFactoryInstance instance;
        block14: {
            MessageBroker mb;
            instance = new JavaFactoryInstance(this, id, properties);
            if (properties == null) {
                instance.setSource(instance.getId());
                instance.setScope("request");
                instance.setAttributeId(id);
            } else {
                instance.setSource(properties.getPropertyAsString("source", instance.getId()));
                instance.setScope(properties.getPropertyAsString("scope", "request"));
                instance.setAttributeId(properties.getPropertyAsString(ATTRIBUTE_ID, id));
            }
            if (instance.getScope().equalsIgnoreCase("application")) {
                try {
                    ServletContext ctx;
                    MessageBroker mb2 = FlexContext.getMessageBroker();
                    ServletContext servletContext = ctx = mb2 != null ? mb2.getServletContext() : null;
                    if (ctx == null) {
                        return instance;
                    }
                    ServletContext servletContext2 = ctx;
                    synchronized (servletContext2) {
                        Object inst = ctx.getAttribute(instance.getAttributeId());
                        if (inst == null) {
                            inst = instance.createInstance();
                            ctx.setAttribute(instance.getAttributeId(), inst);
                        } else {
                            Class<?> instClass;
                            Class configuredClass = instance.getInstanceClass();
                            if (configuredClass != (instClass = inst.getClass()) && !configuredClass.isAssignableFrom(instClass)) {
                                ServiceException e = new ServiceException();
                                e.setMessage(10654, new Object[]{instance.getAttributeId(), "application", instance.getId(), instance.getInstanceClass(), inst.getClass()});
                                e.setCode("Server.Processing");
                                throw e;
                            }
                        }
                        instance.applicationInstance = inst;
                        mb2.incrementAttributeIdRefCount(instance.getAttributeId());
                        break block14;
                    }
                }
                catch (Throwable t) {
                    ConfigurationException ex = new ConfigurationException();
                    ex.setMessage(10656, new Object[]{instance.getSource(), id});
                    ex.setRootCause(t);
                    if (Log.isError()) {
                        Log.getLogger((String)"Configuration").error(ex.getMessage() + StringUtils.NEWLINE + ExceptionUtil.toString((Throwable)t));
                    }
                    throw ex;
                }
            }
            if (instance.getScope().equalsIgnoreCase("session") && (mb = FlexContext.getMessageBroker()) != null) {
                mb.incrementAttributeIdRefCount(instance.getAttributeId());
            }
        }
        return instance;
    }

    public Object lookup(FactoryInstance inst) {
        Object instance;
        JavaFactoryInstance factoryInstance = (JavaFactoryInstance)inst;
        if (factoryInstance.getScope().equalsIgnoreCase("application")) {
            instance = factoryInstance.applicationInstance;
        } else if (factoryInstance.getScope().equalsIgnoreCase("session")) {
            FlexSession session = FlexContext.getFlexSession();
            if (session != null) {
                instance = session.getAttribute(factoryInstance.getAttributeId());
                if (instance != null) {
                    Class<?> instClass;
                    Class configuredClass = factoryInstance.getInstanceClass();
                    if (configuredClass != (instClass = instance.getClass()) && !configuredClass.isAssignableFrom(instClass)) {
                        ServiceException e = new ServiceException();
                        e.setMessage(10654, new Object[]{factoryInstance.getAttributeId(), "session", factoryInstance.getId(), factoryInstance.getInstanceClass(), instance.getClass()});
                        e.setCode("Server.Processing");
                        throw e;
                    }
                } else {
                    instance = factoryInstance.createInstance();
                    session.setAttribute(factoryInstance.getAttributeId(), instance);
                }
            } else {
                instance = null;
            }
            if (instance == null) {
                ServiceException e = new ServiceException();
                e.setMessage(10652, new Object[]{factoryInstance.getId()});
                e.setCode("Server.Processing");
                throw e;
            }
        } else {
            instance = factoryInstance.createInstance();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyFactoryInstance(FactoryInstance inst) {
        JavaFactoryInstance factoryInstance = (JavaFactoryInstance)inst;
        if (factoryInstance != null) {
            MessageBroker mb = FlexContext.getMessageBroker();
            String attributeId = factoryInstance.getAttributeId();
            if ("application".equals(factoryInstance.getScope())) {
                ServletContext ctx = mb.getServletContext();
                if (ctx == null) {
                    return;
                }
                ServletContext servletContext = ctx;
                synchronized (servletContext) {
                    int refCount;
                    int n = refCount = mb != null ? mb.decrementAttributeIdRefCount(attributeId) : 0;
                    if (refCount <= 0) {
                        ctx.removeAttribute(attributeId);
                    }
                }
            } else if ("session".equals(factoryInstance.getScope())) {
                int refCount;
                FlexSession session = FlexContext.getFlexSession();
                if (session == null) {
                    return;
                }
                int n = refCount = mb != null ? mb.decrementAttributeIdRefCount(attributeId) : 0;
                if (refCount <= 0) {
                    session.removeAttribute(attributeId);
                }
            }
            if (factoryInstance.applicationInstance instanceof FlexSessionListener) {
                FlexSession.removeSessionCreatedListener((FlexSessionListener)factoryInstance.applicationInstance);
            }
        }
    }
}

