/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services;

import flex.messaging.FlexContext;
import flex.messaging.FlexSession;
import flex.messaging.MessageBroker;
import flex.messaging.MessageException;
import flex.messaging.client.FlexClient;
import flex.messaging.config.ConfigMap;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.log.Log;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import flex.messaging.security.LoginManager;
import flex.messaging.security.SecurityException;
import flex.messaging.services.AbstractService;
import flex.messaging.services.AuthenticationEvent;
import flex.messaging.services.AuthenticationListener;
import flex.messaging.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.concurrent.CopyOnWriteArrayList;

public class AuthenticationService
extends AbstractService {
    private static final int INVALID_CREDENTIALS_ERROR = 10064;
    public static final String ID = "authentication-service";
    private final CopyOnWriteArrayList<AuthenticationListener> authenticationListeners = new CopyOnWriteArrayList();

    public AuthenticationService() {
        this(false);
    }

    public AuthenticationService(boolean enableManagement) {
        super(false);
        super.setId(ID);
    }

    public void addAuthenticationListener(AuthenticationListener listener) {
        this.authenticationListeners.addIfAbsent(listener);
    }

    public void removeAuthenticationListener(AuthenticationListener listener) {
        this.authenticationListeners.remove(listener);
    }

    public void setId(String id) {
    }

    public ConfigMap describeService(Endpoint endpoint) {
        return null;
    }

    public Object serviceMessage(Message message) {
        return null;
    }

    public Object serviceCommand(CommandMessage msg) {
        LoginManager lm = this.getMessageBroker().getLoginManager();
        switch (msg.getOperation()) {
            case 8: {
                if (!(msg.getBody() instanceof String)) break;
                String encoded = (String)msg.getBody();
                Object charsetHeader = msg.getHeader("DSCredentialsCharset");
                if (charsetHeader instanceof String) {
                    this.decodeAndLoginWithCharset(encoded, lm, (String)charsetHeader);
                    break;
                }
                this.decodeAndLoginWithCharset(encoded, lm, null);
                break;
            }
            case 9: {
                AuthenticationEvent logoutEvent = this.buildAuthenticationEvent(null, null);
                lm.logout();
                for (AuthenticationListener listener : this.authenticationListeners) {
                    try {
                        listener.logoutSucceeded(logoutEvent);
                    }
                    catch (Throwable t) {
                        if (!Log.isError()) continue;
                        Log.getLogger((String)"Security").error("AuthenticationListener {0} threw an exception handling a logout event.", new Object[]{listener}, t);
                    }
                }
                break;
            }
            default: {
                throw new MessageException("Service Does Not Support Command Type " + msg.getOperation());
            }
        }
        return "success";
    }

    public void stop() {
        super.stop();
        this.authenticationListeners.clear();
    }

    public void decodeAndLogin(String encoded, LoginManager lm) {
        this.decodeAndLoginWithCharset(encoded, lm, null);
    }

    private void decodeAndLoginWithCharset(String encoded, LoginManager lm, String charset) {
        int colon;
        String username = null;
        String password = null;
        Base64.Decoder decoder = new Base64.Decoder();
        decoder.decode(encoded);
        String decoded = "";
        if (charset != null) {
            try {
                decoded = new String(decoder.drain(), charset);
            }
            catch (UnsupportedEncodingException ex) {}
        } else {
            decoded = new String(decoder.drain());
        }
        if ((colon = decoded.indexOf(":")) > 0 && colon < decoded.length() - 1) {
            username = decoded.substring(0, colon);
            password = decoded.substring(colon + 1);
        }
        if (username != null && password != null) {
            lm.login(username, password);
            AuthenticationEvent loginEvent = this.buildAuthenticationEvent(username, password);
            for (AuthenticationListener listener : this.authenticationListeners) {
                try {
                    listener.loginSucceeded(loginEvent);
                }
                catch (Throwable t) {
                    if (!Log.isError()) continue;
                    Log.getLogger((String)"Security").error("AuthenticationListener {0} threw an exception handling a login event.", new Object[]{listener}, t);
                }
            }
        } else {
            SecurityException se = new SecurityException();
            se.setCode("Client.Authentication");
            se.setMessage(10064);
            throw se;
        }
    }

    protected void setupServiceControl(MessageBroker broker) {
    }

    private AuthenticationEvent buildAuthenticationEvent(String username, Object credentials) {
        Principal principal = FlexContext.getUserPrincipal();
        FlexClient flexClient = FlexContext.getFlexClient();
        FlexSession flexSession = FlexContext.getFlexSession();
        return new AuthenticationEvent(this, username, credentials, principal, flexSession, flexClient);
    }
}

