/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.messaging.adapters;

import flex.messaging.MessageException;
import flex.messaging.services.messaging.adapters.JMSProducer;
import java.io.Serializable;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSTopicProducer
extends JMSProducer {
    private TopicPublisher publisher;

    @Override
    public void start() throws NamingException, JMSException {
        super.start();
        Topic topic = null;
        try {
            topic = (Topic)this.destination;
        }
        catch (ClassCastException cce) {
            MessageException me = new MessageException();
            me.setMessage(10815, new Object[]{this.destinationJndiName, this.destination.getClass().getName()});
            throw me;
        }
        try {
            TopicConnectionFactory topicFactory = (TopicConnectionFactory)this.connectionFactory;
            this.connection = this.connectionCredentials != null ? topicFactory.createTopicConnection(this.connectionCredentials.getUsername(), this.connectionCredentials.getPassword()) : topicFactory.createTopicConnection();
        }
        catch (ClassCastException cce) {
            MessageException me = new MessageException();
            me.setMessage(10816, new Object[]{this.destinationJndiName, this.connectionFactory.getClass().getName()});
            throw me;
        }
        TopicConnection topicConnection = (TopicConnection)this.connection;
        this.session = topicConnection.createTopicSession(false, this.getAcknowledgeMode());
        TopicSession topicSession = (TopicSession)this.session;
        this.publisher = topicSession.createPublisher(topic);
        this.producer = this.publisher;
        this.connection.start();
    }

    @Override
    void sendObjectMessage(Serializable obj, Map properties) throws JMSException {
        if (obj == null) {
            return;
        }
        ObjectMessage message = this.session.createObjectMessage();
        message.setObject(obj);
        this.copyHeadersToProperties(properties, (Message)message);
        this.publisher.publish((Message)message, this.getDeliveryMode(), this.messagePriority, this.getTimeToLive(properties));
    }

    @Override
    void sendTextMessage(String text, Map properties) throws JMSException {
        if (text == null) {
            return;
        }
        TextMessage message = this.session.createTextMessage();
        message.setText(text);
        this.copyHeadersToProperties(properties, (Message)message);
        this.publisher.publish((Message)message, this.getDeliveryMode(), this.messagePriority, this.getTimeToLive(properties));
    }

    @Override
    void sendMapMessage(Map<String, ?> map, Map properties) throws JMSException {
        if (map == null) {
            return;
        }
        MapMessage message = this.session.createMapMessage();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            message.setObject(entry.getKey(), entry.getValue());
        }
        this.copyHeadersToProperties(properties, (Message)message);
        this.publisher.publish((Message)message, this.getDeliveryMode(), this.messagePriority, this.getTimeToLive(properties));
    }
}

