/*
 * Decompiled with CFR 0.152.
 */
package flex.rds.server.servlet.internal;

import flex.messaging.FactoryDestination;
import flex.messaging.MessageBroker;
import flex.messaging.services.Service;
import flex.messaging.services.remoting.adapters.JavaAdapter;
import flex.messaging.services.remoting.adapters.RemotingMethod;
import flex.rds.server.servlet.internal.ArgumentInfo;
import flex.rds.server.servlet.internal.AttributeInfo;
import flex.rds.server.servlet.internal.EntityInfo;
import flex.rds.server.servlet.internal.FunctionInfo;
import flex.rds.server.servlet.internal.JavaIntrospectorUtil;
import flex.rds.server.servlet.internal.JavatoFiberTypeMap;
import flex.rds.server.servlet.internal.LCDSIntrospectionException;
import flex.rds.server.servlet.internal.ModelInfo;
import flex.rds.server.servlet.internal.PropertyStructure;
import flex.rds.server.servlet.internal.ServiceInfo;
import flex.rds.server.servlet.internal.TypeInfo;
import flex.rds.server.util.RB;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaIntrospector {
    private Class<?> classObject;
    private String _destinationId = null;
    private Set<Method> publicMethods = new HashSet<Method>();
    private Set<Class<?>> typeSet = new HashSet();
    private MessageBroker _messageBroker;
    private ModelInfo modelInfo = new ModelInfo();

    public JavaIntrospector(MessageBroker messageBroker, String destinationId) {
        this._messageBroker = messageBroker;
        this._destinationId = destinationId;
    }

    public String getClassDataAsXMLString() throws LCDSIntrospectionException {
        ServiceInfo serviceInfo;
        Method[] methods;
        if (this._destinationId == null) {
            return null;
        }
        Service service = this._messageBroker.getServiceByType("flex.messaging.services.RemotingService");
        FactoryDestination destination = (FactoryDestination)service.getDestination(this._destinationId);
        if (destination == null) {
            throw new LCDSIntrospectionException(RB.getString((Object)this, "LCDSJavaIntrospectorServlet.DestinationDoesnotExistMessage", (Object)this._destinationId));
        }
        JavaAdapter javaAdapter = null;
        if (destination.getAdapter() instanceof JavaAdapter) {
            javaAdapter = (JavaAdapter)destination.getAdapter();
        }
        String className = destination.getSource();
        try {
            this.classObject = Class.forName(className);
            if (this.classObject.isInterface()) {
                throw new LCDSIntrospectionException(RB.getString((Object)this, "LCDSJavaIntrospectorServlet.InterfaceIntrospectionExceptionMessage", (Object)className));
            }
        }
        catch (ClassNotFoundException e) {
            throw new LCDSIntrospectionException(RB.getString((Object)this, "LCDSJavaIntrospectorServlet.ClassNotFoundExceptionMessage", (Object)className));
        }
        catch (SecurityException e) {
            throw new LCDSIntrospectionException(RB.getString((Object)this, "LCDSJavaIntrospectorServlet.SecurityExceptionMessage", (Object)this.classObject.getCanonicalName()));
        }
        if (Modifier.isAbstract(this.classObject.getModifiers())) {
            throw new LCDSIntrospectionException(RB.getString((Object)this, "LCDSJavaIntrospectorServlet.AbstractClassIntrospectionExceptionMessage", (Object)this.classObject.getCanonicalName()));
        }
        HashSet<String> includedMethodNameSet = new HashSet<String>();
        HashSet<String> excludedMethodNameSet = new HashSet<String>();
        if (javaAdapter != null) {
            Iterator excludeMethodIterator = javaAdapter.getExcludeMethodIterator();
            Iterator includeMethodIterator = javaAdapter.getIncludeMethodIterator();
            if (includeMethodIterator != null) {
                while (includeMethodIterator.hasNext()) {
                    RemotingMethod includedRemotingMethod = (RemotingMethod)includeMethodIterator.next();
                    includedMethodNameSet.add(includedRemotingMethod.getName());
                }
            }
            if (excludeMethodIterator != null) {
                while (excludeMethodIterator.hasNext()) {
                    RemotingMethod excludedRemotingMethod = (RemotingMethod)excludeMethodIterator.next();
                    excludedMethodNameSet.add(excludedRemotingMethod.getName());
                }
            }
        }
        if ((methods = this.classObject.getMethods()) != null) {
            HashSet<String> tempMethodNameSet = new HashSet<String>();
            for (Method method : methods) {
                if (includedMethodNameSet.size() > 0 && !includedMethodNameSet.contains(method.getName()) || excludedMethodNameSet.contains(method.getName()) || method.getDeclaringClass() == Object.class) continue;
                if (!tempMethodNameSet.add(method.getName())) {
                    throw new LCDSIntrospectionException(RB.getString((Object)this, "LCDSJavaIntrospectorServlet.OverloadedMethodsUnsupportedException", (Object)className));
                }
                this.publicMethods.add(method);
            }
        }
        for (Method method : this.publicMethods) {
            Class<?> returnType = method.getReturnType();
            Type genericReturnType = method.getGenericReturnType();
            this.introspect(genericReturnType, returnType);
            Class<?>[] parameters = method.getParameterTypes();
            Type[] genericparameters = method.getGenericParameterTypes();
            if (parameters == null || genericparameters == null) continue;
            for (int i = 0; i < parameters.length; ++i) {
                this.introspect(genericparameters[i], parameters[i]);
            }
        }
        this.modelInfo.serviceInfo = serviceInfo = this.createServiceInfo();
        return this.modelInfo.getXML();
    }

    private void introspect(Type genericType, Class<?> class1) throws LCDSIntrospectionException {
        if (JavatoFiberTypeMap.isJavaCollection(class1)) {
            ParameterizedType parameterizedType;
            Type[] typeArguments;
            if (genericType instanceof ParameterizedType && (typeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()) != null && typeArguments.length == 1) {
                Type firstTypeArgument = typeArguments[0];
                if (firstTypeArgument instanceof ParameterizedType) {
                    ParameterizedType firstParametterizedTypeArgument = (ParameterizedType)firstTypeArgument;
                    Type firstRawTypeArgument = firstParametterizedTypeArgument.getRawType();
                    if (firstRawTypeArgument instanceof Class) {
                        this.introspect((Class)firstRawTypeArgument);
                    }
                } else if (firstTypeArgument instanceof Class) {
                    this.introspect((Class)firstTypeArgument);
                }
            }
        } else {
            this.introspect(class1);
        }
    }

    private ServiceInfo createServiceInfo() {
        TypeInfo serviceTypeInfo;
        ServiceInfo serviceInfo = new ServiceInfo();
        serviceInfo.serviceTypeInfo = serviceTypeInfo = new TypeInfo();
        serviceTypeInfo.fiberType = JavaIntrospectorUtil.getFiberEquivalentType(null, this.classObject) + "_Service";
        serviceTypeInfo.javaType = this.classObject.getCanonicalName();
        serviceInfo.functionInfos = new ArrayList();
        for (Method method : this.publicMethods) {
            TypeInfo returnTypeInfo;
            FunctionInfo functionInfo = new FunctionInfo();
            serviceInfo.functionInfos.add(functionInfo);
            functionInfo.functionName = method.getName();
            functionInfo.returnTypeInfo = returnTypeInfo = new TypeInfo();
            returnTypeInfo.javaType = method.getReturnType().getCanonicalName();
            returnTypeInfo.fiberType = JavaIntrospectorUtil.getFiberEquivalentType(method.getGenericReturnType(), method.getReturnType());
            Class<?>[] parameterTypes = method.getParameterTypes();
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                TypeInfo argumentTypeInfo;
                Class<?> parameterType = parameterTypes[i];
                Type genericParameterType = genericParameterTypes[i];
                ArgumentInfo argumentInfo = new ArgumentInfo();
                functionInfo.argumentInfos.add(argumentInfo);
                argumentInfo.argumentTypeInfo = argumentTypeInfo = new TypeInfo();
                argumentTypeInfo.javaType = parameterType.getCanonicalName();
                argumentTypeInfo.fiberType = JavaIntrospectorUtil.getFiberEquivalentType(genericParameterType, parameterType);
                argumentInfo.argumentName = "arg" + i;
            }
        }
        return serviceInfo;
    }

    private void introspect(Class<?> class1) throws LCDSIntrospectionException {
        if (class1 == null) {
            return;
        }
        if (class1.isArray()) {
            Class<?> componentType = class1.getComponentType();
            if (componentType == null || componentType.isArray()) {
                return;
            }
            this.introspect(componentType);
            return;
        }
        if (JavaIntrospectorUtil.addToTypeSet(class1, this.typeSet)) {
            PropertyDescriptor[] propertyDescriptors;
            Field[] fields;
            HashSet<PropertyStructure> propertySet = new HashSet<PropertyStructure>();
            for (Field field : fields = class1.getFields()) {
                PropertyStructure property = new PropertyStructure();
                property.propertyName = field.getName();
                property.propertyClass = field.getType();
                property.genericType = field.getGenericType();
                int fieldModifier = field.getModifiers();
                if (!JavaIntrospectorUtil.isPublicField(fieldModifier)) continue;
                propertySet.add(property);
                this.introspect(field.getGenericType(), field.getType());
            }
            BeanInfo beanInfo = null;
            try {
                beanInfo = Introspector.getBeanInfo(class1);
            }
            catch (IntrospectionException e) {
                // empty catch block
            }
            if (beanInfo != null && (propertyDescriptors = beanInfo.getPropertyDescriptors()) != null) {
                for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                    Method readMethod;
                    if (propertyDescriptor == null || (readMethod = propertyDescriptor.getReadMethod()) == null || !JavaIntrospectorUtil.isPublicAccessor(readMethod.getModifiers()) || propertyDescriptor.getPropertyType() == Class.class && propertyDescriptor.getName().equals("class")) continue;
                    PropertyStructure property = new PropertyStructure();
                    property.propertyName = propertyDescriptor.getName();
                    property.propertyClass = propertyDescriptor.getPropertyType();
                    property.genericType = readMethod.getGenericReturnType();
                    propertySet.add(property);
                    Type genericReturnType = readMethod.getGenericReturnType();
                    this.introspect(genericReturnType, propertyDescriptor.getPropertyType());
                }
            }
            EntityInfo entityInfo = this.createEntityInfo(class1, propertySet);
            this.modelInfo.addEntityInfo(class1, entityInfo);
        }
    }

    private EntityInfo createEntityInfo(Class<?> class1, Set<PropertyStructure> propertySet) {
        EntityInfo dataServiceEntityInfo = new EntityInfo();
        for (PropertyStructure property : propertySet) {
            dataServiceEntityInfo.addAttributeInfo(this.createAttributeInfo(property));
        }
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.fiberType = JavaIntrospectorUtil.getFiberEquivalentType(null, class1);
        typeInfo.javaType = class1.getCanonicalName();
        dataServiceEntityInfo.entityTypeInfo = typeInfo;
        return dataServiceEntityInfo;
    }

    private AttributeInfo createAttributeInfo(PropertyStructure property) {
        AttributeInfo dataServiceAttributeInfo = new AttributeInfo();
        dataServiceAttributeInfo.attriuteName = property.propertyName;
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.fiberType = JavaIntrospectorUtil.getFiberEquivalentType(property.genericType, property.propertyClass);
        typeInfo.javaType = property.propertyClass.getCanonicalName();
        dataServiceAttributeInfo.attributeTypeInfo = typeInfo;
        return dataServiceAttributeInfo;
    }
}

