/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.javaquery;

import com.akamai.javaquery.Q2Future;
import com.akamai.javaquery.Q2PublishCallback;
import com.akamai.javaquery.Q2Statement;
import com.akamai.javaquery.enums.Q2ConnType;
import com.akamai.javaquery.exceptions.Q2ConnectionException;
import com.akamai.javaquery.exceptions.Q2QueryException;
import com.akamai.javaquery.sqlWrappers.ConnectionWrapper;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Q2Connection
extends ConnectionWrapper {
    private final long connPtr;
    private final boolean publishing;
    private final String identifier;
    private AtomicInteger queryTimeout = new AtomicInteger(3600);
    private int maxRows = -1;
    private Set<Q2Future> futures = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<Q2PublishCallback> callbacks = Collections.newSetFromMap(new ConcurrentHashMap());
    private AtomicBoolean closed = new AtomicBoolean();

    Q2Connection(String identifier, String serverName, EnumSet<Q2ConnType> enums) throws Q2ConnectionException {
        if (serverName == null) {
            throw new NullPointerException("ServerName is null");
        }
        if (identifier == null || enums == null) {
            throw new NullPointerException("A parameter to getConnection() is null");
        }
        int flags = 0;
        for (Q2ConnType e : enums) {
            flags |= e.getCode();
        }
        this.identifier = identifier;
        this.connPtr = this.init(identifier, serverName, flags);
        if (this.connPtr == 0L) {
            throw new Q2ConnectionException("Attempt to establish a Q2Connection failed");
        }
        this.setQueryTimeout(this.queryTimeout.get());
        this.publishing = enums.contains((Object)Q2ConnType.PUBLISH);
    }

    @Override
    public Q2Statement createStatement() {
        this.checkClosed();
        return new Q2Statement(this);
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public boolean isReadOnly() {
        this.checkClosed();
        return !this.publishing;
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.closed.set(true);
        this.exit(this.connPtr);
        for (Q2Future f : this.futures) {
            f.cancel();
            f.deleteGlobalRef();
        }
        this.futures.clear();
        for (Q2PublishCallback pcb : this.callbacks) {
            pcb.takeDownWithoutDeregisterCallback();
        }
        this.callbacks.clear();
    }

    public String getIdentifier() {
        this.checkClosed();
        return this.identifier;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.checkClosed();
        if (this.publishing) {
            throw new IllegalStateException("Can't set query timeout on publishing connection");
        }
        if (queryTimeout <= 0) {
            throw new ArithmeticException("queryTimeout is <= 0");
        }
        this.queryTimeout.set(queryTimeout);
        this.set_query_timeout(this.connPtr, queryTimeout);
    }

    void setQueryTimeoutTest(int queryTimeout) {
        this.queryTimeout.set(queryTimeout);
    }

    public int getQueryTimeout() {
        this.checkClosed();
        if (this.publishing) {
            throw new IllegalStateException("Can't get query timeout on publishing connection");
        }
        return this.queryTimeout.get();
    }

    public String setMaxRows(int maxRows) throws Q2QueryException {
        this.checkClosed();
        if (this.publishing) {
            throw new IllegalStateException("Can't set max rows on publishing connection");
        }
        String info = this.createStatement().executeCommand("SET rlimit_max_rows_returned " + maxRows + ";");
        this.maxRows = maxRows;
        return info;
    }

    public int getMaxRows() {
        this.checkClosed();
        if (this.publishing) {
            throw new IllegalStateException("Can't get max rows on publishing connection");
        }
        return this.maxRows;
    }

    long getConnPtr() {
        return this.connPtr;
    }

    boolean isPublishing() {
        this.checkClosed();
        return this.publishing;
    }

    void checkClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Q2Connection is closed");
        }
    }

    void registerFuture(Q2Future f) {
        this.futures.add(f);
    }

    void deregisterFuture(Q2Future f) {
        this.futures.remove(f);
    }

    int testSizeofFutures() {
        return this.futures.size();
    }

    void registerCallback(Q2PublishCallback pcb) {
        this.callbacks.add(pcb);
    }

    void deregisterCallback(Q2PublishCallback pcb) {
        this.callbacks.remove(pcb);
    }

    int testSizeofCallbacks() {
        return this.callbacks.size();
    }

    private native long init(String var1, String var2, int var3);

    private native void exit(long var1);

    private native int set_query_timeout(long var1, long var3);
}

