/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.javaquery;

import com.akamai.javaquery.Q2Connection;
import com.akamai.javaquery.Q2QueryCallback;
import com.akamai.javaquery.Q2ResultTable;
import com.akamai.javaquery.Q2Statement;
import com.akamai.javaquery.exceptions.Q2QueryException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Q2Future
implements Future<Q2ResultTable> {
    private boolean done;
    private boolean cancelled;
    private boolean timedOut;
    private boolean deleted;
    private final Object lock = new Object();
    private final boolean ddl;
    private Q2ResultTable rt;
    private Q2QueryException queryException;
    private Q2Statement stmnt;
    private Q2Connection conn;
    private long argsPtr;
    private final long timeQueryExecuted;
    private static final int TIMEOUT_CONST = 360000;
    private long queryTimeoutPlusConst;
    private final Q2QueryCallback queryCallback;

    Q2Future(String sql, boolean ddl, Q2Statement stmnt) throws Q2QueryException {
        this(sql, ddl, stmnt, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Q2Future(String sql, boolean ddl, Q2Statement stmnt, Q2QueryCallback qcb) throws Q2QueryException {
        this.ddl = ddl;
        this.stmnt = stmnt;
        this.conn = stmnt.getConnection();
        stmnt.checkIsPublishing(false);
        this.conn.checkClosed();
        this.queryCallback = qcb;
        if (sql == null) {
            throw new NullPointerException("sql string is null.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.conn.registerFuture(this);
            this.argsPtr = Q2Statement.make_global_ref(this);
            int status = Q2Statement.issue_query_async(this.conn.getConnPtr(), sql, this.argsPtr);
            this.timeQueryExecuted = System.currentTimeMillis();
            this.queryTimeoutPlusConst = this.conn.getQueryTimeout() * 1000 + 360000;
            switch (status) {
                case -2: {
                    this.done();
                    throw new Q2QueryException("User Error");
                }
                case -1: {
                    this.done();
                    throw new Q2QueryException("No memory");
                }
            }
        }
    }

    @Override
    public Q2ResultTable get() throws ExecutionException {
        Q2ResultTable rt = null;
        try {
            rt = this.get(0L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
        }
        catch (InterruptedException ie) {
            throw new ExecutionException(ie);
        }
        return rt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.lock;
        synchronized (object) {
            long queryTimeoutAt = this.queryTimeoutPlusConst + this.timeQueryExecuted;
            if (System.currentTimeMillis() > queryTimeoutAt) {
                this.timedOut = true;
                this.done = true;
            }
            return this.done;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callback(long tablePtr) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.rt = new Q2ResultTable(tablePtr, this.stmnt, this.ddl);
            }
            catch (Q2QueryException qe) {
                this.queryException = qe;
            }
            if (this.isDone() && this.rt != null) {
                this.rt.close();
            }
            this.done();
            if (this.rt == null || this.rt.isClosed()) {
                return;
            }
        }
        if (this.queryCallback != null) {
            this.queryCallback.setupAndRun(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isDone()) {
                return false;
            }
            this.done = true;
            if (mayInterruptIfRunning) {
                this.cancelled = true;
                this.lock.notifyAll();
                return true;
            }
            return false;
        }
    }

    public boolean cancel() {
        return this.cancel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Q2ResultTable get(long time, TimeUnit unit) throws ExecutionException, TimeoutException, InterruptedException {
        boolean userTimeoutFirst = true;
        long queryTimeoutAt = this.queryTimeoutPlusConst + this.timeQueryExecuted;
        long timeoutAt = unit.toMillis(time) + System.currentTimeMillis();
        if (queryTimeoutAt < timeoutAt || time <= 0L) {
            userTimeoutFirst = false;
            timeoutAt = queryTimeoutAt;
        }
        Object object = this.lock;
        synchronized (object) {
            while (!this.done) {
                long timeLeft = timeoutAt - System.currentTimeMillis();
                if (timeLeft <= 0L) {
                    this.timedOut = true;
                    break;
                }
                this.lock.wait(timeLeft);
            }
            if (this.cancelled) {
                throw new CancellationException("Query cancelled");
            }
            if (this.timedOut) {
                if (userTimeoutFirst) {
                    throw new TimeoutException();
                }
                this.done();
                throw new ExecutionException(new Q2QueryException("Query timeout exceeded, but query2lib failed to indicate a timeout error"));
            }
            if (this.queryException != null) {
                throw new ExecutionException(this.queryException);
            }
            return this.rt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.lock;
        synchronized (object) {
            return this.cancelled;
        }
    }

    private void done() {
        this.done = true;
        this.lock.notifyAll();
        this.deleteGlobalRef();
        this.conn.deregisterFuture(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteGlobalRef() {
        Object object = this.lock;
        synchronized (object) {
            if (this.deleted) {
                return;
            }
            Q2Statement.delete_global_ref(this.argsPtr);
            this.deleted = true;
        }
    }

    public Q2Statement getStatement() {
        return this.stmnt;
    }
}

