/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.chunk;

import com.aliasi.chunk.OutcomeCounter;
import com.aliasi.symbol.SymbolTableCompiler;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class Node {
    float mOneMinusLambda;
    private int mIndex = -1;
    private int mTotalCount = 0;
    private short mNumOutcomes = 0;
    private final Map<String, Node> mChildren = new TreeMap<String, Node>();
    private final Map<String, OutcomeCounter> mOutcomes = new TreeMap<String, OutcomeCounter>();
    private final Node mBackoffNode;
    private final SymbolTableCompiler mSymbolTable;
    private final String mSymbol;

    public Node(String symbol, SymbolTableCompiler symbolTable, Node backoffNode) {
        this.mSymbol = symbol;
        if (symbolTable == null) {
            throw new IllegalArgumentException("Null table.");
        }
        this.mSymbolTable = symbolTable;
        if (symbol != null) {
            symbolTable.addSymbol(symbol);
        }
        this.mBackoffNode = backoffNode;
    }

    public void printSymbols() {
        if (this.mSymbolTable == null) {
            System.out.println("NULL Symbol TABLE");
        }
        System.out.println(this.mSymbolTable.toString());
    }

    public int getSymbolID() {
        if (this.mSymbol == null) {
            return -1;
        }
        return this.mSymbolTable.symbolToID(this.mSymbol);
    }

    public void generateSymbols() {
        if (this.mSymbol != null) {
            this.mSymbolTable.addSymbol(this.mSymbol);
        }
        for (OutcomeCounter counter : this.mOutcomes.values()) {
            counter.addSymbolToTable();
        }
        for (Node child : this.mChildren.values()) {
            child.generateSymbols();
        }
    }

    public int index() {
        return this.mIndex;
    }

    public void setIndex(int index) {
        this.mIndex = index;
    }

    public void prune(int threshold) {
        Iterator<String> outcomes = this.outcomes().iterator();
        while (outcomes.hasNext()) {
            OutcomeCounter counter = this.getOutcome(outcomes.next());
            if (counter.count() >= threshold) continue;
            this.mTotalCount -= counter.count();
            this.mNumOutcomes = (short)(this.mNumOutcomes - 1);
            outcomes.remove();
        }
        Iterator<String> childrenIt = this.children().iterator();
        while (childrenIt.hasNext()) {
            Node childNode = this.getChild(childrenIt.next());
            childNode.prune(threshold);
            if (childNode.totalCount() >= threshold) continue;
            childrenIt.remove();
        }
    }

    public int numNodes() {
        int count = 1;
        for (String childString : this.children()) {
            count += this.getChild(childString).numNodes();
        }
        return count;
    }

    public int numCounters() {
        int count = this.mOutcomes.keySet().size();
        for (String childString : this.children()) {
            count += this.getChild(childString).numCounters();
        }
        return count;
    }

    public boolean hasOutcome(String outcome) {
        return this.mOutcomes.containsKey(outcome);
    }

    public OutcomeCounter getOutcome(String outcome) {
        return this.mOutcomes.get(outcome);
    }

    public boolean hasChild(String child) {
        return this.mChildren.containsKey(child);
    }

    public Node getChild(String child) {
        return this.mChildren.get(child);
    }

    public Node getOrCreateChild(String child, Node backoffNode, SymbolTableCompiler symbolTable) {
        if (this.hasChild(child)) {
            return this.getChild(child);
        }
        Node node = new Node(child, symbolTable, backoffNode);
        this.mChildren.put(child, node);
        return node;
    }

    public Set<String> outcomes() {
        return this.mOutcomes.keySet();
    }

    public Set<String> children() {
        return this.mChildren.keySet();
    }

    public int outcomeCount(String outcome) {
        OutcomeCounter ctr = this.getOutcome(outcome);
        return ctr == null ? 0 : ctr.count();
    }

    public void incrementOutcome(String outcome, SymbolTableCompiler symbolTable) {
        ++this.mTotalCount;
        if (this.hasOutcome(outcome)) {
            this.getOutcome(outcome).increment();
        } else {
            this.mNumOutcomes = (short)(this.mNumOutcomes + 1);
            this.mOutcomes.put(outcome, new OutcomeCounter(outcome, symbolTable, 1));
        }
    }

    public int totalCount() {
        return this.mTotalCount;
    }

    public float oneMinusLambda() {
        return this.mOneMinusLambda;
    }

    public void compileEstimates(double lambdaFactor) {
        this.mOneMinusLambda = (float)Math.log(1.0 - this.lambda(lambdaFactor));
        for (String outcome : this.outcomes()) {
            this.getOutcome(outcome).setEstimate((float)this.logEstimate(outcome, lambdaFactor));
        }
        for (String childString : this.children()) {
            Node child = this.getChild(childString);
            child.compileEstimates(lambdaFactor);
        }
    }

    public double logEstimate(String outcome, double lambdaFactor) {
        return Math.log(this.estimate(outcome, lambdaFactor));
    }

    public Node backoffNode() {
        return this.mBackoffNode;
    }

    public double estimate(String outcome, double lambdaFactor) {
        if (this.mBackoffNode == null) {
            return this.maxLikelihoodEstimate(outcome);
        }
        double lambda = this.lambda(lambdaFactor);
        return lambda * this.maxLikelihoodEstimate(outcome) + (1.0 - lambda) * this.mBackoffNode.estimate(outcome, lambdaFactor);
    }

    public double maxLikelihoodEstimate(String outcome) {
        return (double)this.outcomeCount(outcome) / (double)this.mTotalCount;
    }

    public double lambda(double lambdaFactor) {
        if (this.mTotalCount == 0) {
            return 0.0;
        }
        return (double)this.mTotalCount / ((double)this.mTotalCount + lambdaFactor * (double)this.mNumOutcomes);
    }
}

