/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.cluster;

import com.aliasi.cluster.Dendrogram;
import com.aliasi.cluster.HierarchicalClusterer;
import com.aliasi.util.Distance;
import com.aliasi.util.Scored;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractHierarchicalClusterer<E>
implements HierarchicalClusterer<E> {
    private double mMaxDistance;
    private final Distance<? super E> mDistance;

    public AbstractHierarchicalClusterer(double maxDistance, Distance<? super E> distance) {
        this.setMaxDistance(maxDistance);
        this.mDistance = distance;
    }

    public Distance<? super E> distance() {
        return this.mDistance;
    }

    @Override
    public abstract Dendrogram<E> hierarchicalCluster(Set<? extends E> var1);

    @Override
    public Set<Set<E>> cluster(Set<? extends E> elements) {
        if (elements.isEmpty()) {
            return new HashSet<Set<E>>();
        }
        Dendrogram<E> dendrogram = this.hierarchicalCluster(elements);
        return dendrogram.partitionDistance(this.mMaxDistance);
    }

    public double getMaxDistance() {
        return this.mMaxDistance;
    }

    public final void setMaxDistance(double maxDistance) {
        AbstractHierarchicalClusterer.assertValidDistanceBound(maxDistance);
        this.mMaxDistance = maxDistance;
    }

    static void assertValidDistanceBound(double maxDistance) {
        if (maxDistance < 0.0 || Double.isNaN(maxDistance)) {
            String msg = "Max distance must be non-negative number. Found maxDistance=" + maxDistance;
            throw new IllegalArgumentException(msg);
        }
    }

    E[] toElements(Set<? extends E> elementSet) {
        int len = elementSet.size();
        Object[] elements = new Object[len];
        elementSet.toArray(elements);
        return elements;
    }

    static class PairScore<E>
    implements Scored {
        final Dendrogram<E> mDendrogram1;
        final Dendrogram<E> mDendrogram2;
        final double mScore;

        public PairScore(Dendrogram<E> dendrogram1, Dendrogram<E> dendrogram2, double score) {
            this.mDendrogram1 = dendrogram1;
            this.mDendrogram2 = dendrogram2;
            this.mScore = score;
        }

        @Override
        public double score() {
            return this.mScore;
        }

        public String toString() {
            return "ps(" + this.mDendrogram1 + "," + this.mDendrogram2 + ":" + this.mScore + ") ";
        }
    }
}

