/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.dca;

import com.aliasi.dca.DiscreteChooser;
import com.aliasi.features.Features;
import com.aliasi.io.Reporter;
import com.aliasi.io.Reporters;
import com.aliasi.matrix.Vector;
import com.aliasi.stats.AnnealingSchedule;
import com.aliasi.stats.RegressionPrior;
import com.aliasi.symbol.MapSymbolTable;
import com.aliasi.symbol.SymbolTable;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.FeatureExtractor;
import com.aliasi.util.ObjectToCounterMap;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class DiscreteObjectChooser<E>
implements Serializable {
    static final long serialVersionUID = 3178131664571660923L;
    private final FeatureExtractor<E> mFeatureExtractor;
    private final SymbolTable mFeatureSymbolTable;
    private final DiscreteChooser mChooser;
    static final boolean ADD_INTERCEPT_FALSE = false;

    public DiscreteObjectChooser(FeatureExtractor<E> featureExtractor, SymbolTable featureSymbolTable, DiscreteChooser chooser) {
        this.mFeatureExtractor = featureExtractor;
        this.mFeatureSymbolTable = featureSymbolTable;
        this.mChooser = chooser;
    }

    public FeatureExtractor<E> featureExtractor() {
        return this.mFeatureExtractor;
    }

    public SymbolTable featureSymbolTable() {
        return MapSymbolTable.unmodifiableView(this.mFeatureSymbolTable);
    }

    public DiscreteChooser chooser() {
        return this.mChooser;
    }

    public static <F> DiscreteObjectChooser<F> estimate(FeatureExtractor<F> featureExtractor, List<List<F>> alternativeObjectss, int[] choices, int minFeatureCount, RegressionPrior prior, int priorBlockSize, AnnealingSchedule annealingSchedule, double minImprovement, int minEpochs, int maxEpochs, Reporter reporter) {
        if (reporter == null) {
            reporter = Reporters.silent();
        }
        ObjectToCounterMap<String> featureCounter = new ObjectToCounterMap<String>();
        for (List<F> alternativeObjects : alternativeObjectss) {
            for (F alternativeObject : alternativeObjects) {
                Map<String, Number> featureMap = featureExtractor.features(alternativeObject);
                for (String feature : featureMap.keySet()) {
                    featureCounter.increment(feature);
                }
            }
        }
        featureCounter.prune(minFeatureCount);
        MapSymbolTable featureSymbolTable = new MapSymbolTable();
        for (String feature : featureCounter.keySet()) {
            featureSymbolTable.getOrAddSymbol(feature);
        }
        int numDimensions = featureSymbolTable.numSymbols();
        Vector[][] alternativess = new Vector[alternativeObjectss.size()][];
        for (int i = 0; i < alternativess.length; ++i) {
            List<F> alternativeObjects = alternativeObjectss.get(i);
            alternativess[i] = new Vector[alternativeObjects.size()];
            for (int k = 0; k < alternativess[i].length; ++k) {
                Map<String, Number> featureMap = featureExtractor.features(alternativeObjects.get(k));
                alternativess[i][k] = Features.toVectorAddSymbols(featureMap, featureSymbolTable, numDimensions, false);
            }
        }
        DiscreteChooser chooser = DiscreteChooser.estimate(alternativess, choices, prior, priorBlockSize, annealingSchedule, minImprovement, minEpochs, maxEpochs, reporter);
        return new DiscreteObjectChooser<F>(featureExtractor, featureSymbolTable, chooser);
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    static class Serializer<F>
    extends AbstractExternalizable {
        static final long serialVersionUID = 4420046415835317661L;
        final DiscreteObjectChooser<F> mObjectChooser;

        public Serializer() {
            this(null);
        }

        public Serializer(DiscreteObjectChooser<F> objectChooser) {
            this.mObjectChooser = objectChooser;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(((DiscreteObjectChooser)this.mObjectChooser).mFeatureExtractor);
            out.writeObject(((DiscreteObjectChooser)this.mObjectChooser).mFeatureSymbolTable);
            out.writeObject(((DiscreteObjectChooser)this.mObjectChooser).mChooser);
        }

        @Override
        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            FeatureExtractor featureExtractor = (FeatureExtractor)in.readObject();
            SymbolTable featureSymbolTable = (SymbolTable)in.readObject();
            DiscreteChooser chooser = (DiscreteChooser)in.readObject();
            return new DiscreteObjectChooser(featureExtractor, featureSymbolTable, chooser);
        }
    }
}

