/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.lm;

import com.aliasi.lm.TrieReader;
import java.io.IOException;

abstract class DeletingTrieReader
implements TrieReader {
    private final TrieReader mReader;
    long mNextCount;

    DeletingTrieReader(TrieReader reader) throws IOException {
        this.mReader = reader;
        this.bufferCount();
    }

    @Override
    public long readCount() {
        return this.mNextCount;
    }

    @Override
    public long readSymbol() throws IOException {
        long sym;
        while ((sym = this.mReader.readSymbol()) != -1L) {
            if (this.bufferCount()) {
                return sym;
            }
            this.flushDaughters();
        }
        return -1L;
    }

    long nextCount() throws IOException {
        return this.mReader.readCount();
    }

    abstract boolean bufferCount() throws IOException;

    void flushDaughters() throws IOException {
        while (this.mReader.readSymbol() != -1L) {
            this.mReader.readCount();
            this.flushDaughters();
        }
    }
}

