/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.lm;

import com.aliasi.util.BoundedPriorityQueue;
import com.aliasi.util.ObjectToCounterMap;
import java.util.Comparator;

class NBestCounter
extends BoundedPriorityQueue<NBEntry> {
    static final long serialVersionUID = -1604467508550079460L;
    private final boolean mReversed;
    static Comparator<NBEntry> COMPARATOR = new Comparator<NBEntry>(){

        @Override
        public int compare(NBEntry entry1, NBEntry entry2) {
            return entry1.compareTo(entry2);
        }
    };

    public NBestCounter(int maxEntries) {
        this(maxEntries, false);
    }

    public NBestCounter(int maxEntries, boolean reversed) {
        super(COMPARATOR, maxEntries);
        this.mReversed = reversed;
    }

    public ObjectToCounterMap<String> toObjectToCounter() {
        ObjectToCounterMap<String> otc = new ObjectToCounterMap<String>();
        for (NBEntry entry : this) {
            if (entry.mCount > Integer.MAX_VALUE) {
                String msg = "Entry too large.";
                throw new IllegalArgumentException(msg);
            }
            otc.set(entry.mString, (int)entry.mCount);
        }
        return otc;
    }

    public void put(char[] cs, int length, long count) {
        this.offer(new NBEntry(cs, length, count));
    }

    class NBEntry
    implements Comparable<NBEntry> {
        final String mString;
        final long mCount;

        public NBEntry(char[] cs, int length, long count) {
            this.mString = new String(cs, 0, length);
            this.mCount = count;
        }

        @Override
        public int compareTo(NBEntry thatEntry) {
            if (thatEntry.mCount == this.mCount) {
                return thatEntry.mString.compareTo(this.mString);
            }
            long diff = thatEntry.mCount - this.mCount;
            int comp = diff < 0L ? -1 : (diff > 0L ? 1 : 0);
            return NBestCounter.this.mReversed ? -comp : comp;
        }
    }
}

