/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.lm;

import com.aliasi.lm.LanguageModel;
import com.aliasi.lm.UniformProcessLM;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Exceptions;
import com.aliasi.util.Math;
import com.aliasi.util.Strings;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class UniformBoundaryLM
implements LanguageModel.Dynamic,
LanguageModel.Sequence {
    private final double mLog2EstimatePerChar;
    private final int mNumOutcomes;
    public static final UniformBoundaryLM ZERO_LM = new UniformBoundaryLM(0);

    public UniformBoundaryLM() {
        this(65534);
    }

    public UniformBoundaryLM(int numOutcomes) {
        UniformProcessLM.validateNumOutcomes(numOutcomes + 1);
        this.mNumOutcomes = numOutcomes;
        this.mLog2EstimatePerChar = -Math.log2(1.0 + (double)numOutcomes);
    }

    public UniformBoundaryLM(double crossEntropyRate) {
        Exceptions.finiteNonNegative("Cross-entropy rate", crossEntropyRate);
        this.mLog2EstimatePerChar = -crossEntropyRate;
        this.mNumOutcomes = java.lang.Math.max(0, (int)(java.lang.Math.pow(2.0, crossEntropyRate) - 1.0));
    }

    private UniformBoundaryLM(int numOutcomes, double log2EstimatePerChar) {
        this.mNumOutcomes = numOutcomes;
        this.mLog2EstimatePerChar = log2EstimatePerChar;
    }

    public int numOutcomes() {
        return this.mNumOutcomes;
    }

    @Override
    public void compileTo(ObjectOutput objOut) throws IOException {
        objOut.writeObject(new Externalizer(this));
    }

    @Override
    public void train(char[] cs, int start, int end) {
    }

    @Override
    public void train(char[] cs, int start, int end, int count) {
    }

    @Override
    public void train(CharSequence cSeq) {
    }

    @Override
    public void train(CharSequence cSeq, int count) {
    }

    @Override
    public double log2Estimate(char[] cs, int start, int end) {
        Strings.checkArgsStartEnd(cs, start, end);
        return this.log2Estimate(end - start);
    }

    @Override
    public double log2Estimate(CharSequence cSeq) {
        return this.log2Estimate(cSeq.length());
    }

    private double log2Estimate(int length) {
        return this.mLog2EstimatePerChar * (1.0 + (double)length);
    }

    private static UniformBoundaryLM createUniformBoundaryLM(int numOutcomes, double log2EstimatePerChar) {
        return new UniformBoundaryLM(numOutcomes, log2EstimatePerChar);
    }

    private static class Externalizer
    extends AbstractExternalizable {
        static final long serialVersionUID = -5389627995529538230L;
        private final UniformBoundaryLM mLM;

        public Externalizer() {
            this.mLM = null;
        }

        public Externalizer(UniformBoundaryLM lm) {
            this.mLM = lm;
        }

        @Override
        public Object read(ObjectInput objIn) throws IOException {
            int numOutcomes = objIn.readInt();
            double log2EstimatePerChar = objIn.readDouble();
            return UniformBoundaryLM.createUniformBoundaryLM(numOutcomes, log2EstimatePerChar);
        }

        @Override
        public void writeExternal(ObjectOutput objOut) throws IOException {
            objOut.writeInt(this.mLM.numOutcomes());
            objOut.writeDouble(this.mLM.mLog2EstimatePerChar);
        }
    }
}

