/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.matrix;

import com.aliasi.matrix.DenseVector;
import com.aliasi.matrix.Vector;

public abstract class AbstractVector
implements Vector {
    protected AbstractVector() {
    }

    @Override
    public int[] nonZeroDimensions() {
        int count = 0;
        for (int i = 0; i < this.numDimensions(); ++i) {
            if (this.value(i) == 0.0) continue;
            ++count;
        }
        int[] result = new int[count];
        int pos = 0;
        for (int i = 0; i < this.numDimensions(); ++i) {
            if (this.value(i) == 0.0) continue;
            result[pos++] = i;
        }
        return result;
    }

    @Override
    public void increment(double scale, Vector v) {
        if (v.numDimensions() != this.numDimensions()) {
            String msg = "Specified vector not same dimensionality. Found this.numDimensions()=" + this.numDimensions() + " v.numDimensions()=" + v.numDimensions();
            throw new IllegalArgumentException(msg);
        }
        for (int i = 0; i < this.numDimensions(); ++i) {
            this.setValue(i, this.value(i) + scale * v.value(i));
        }
    }

    @Override
    public abstract int numDimensions();

    @Override
    public abstract double value(int var1);

    @Override
    public void setValue(int dimension, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double length() {
        double length = 0.0;
        int i = this.numDimensions();
        while (--i >= 0) {
            double val = this.value(i);
            length += val * val;
        }
        return Math.sqrt(length);
    }

    @Override
    public Vector add(Vector v) {
        int numDimensions = this.numDimensions();
        if (v.numDimensions() != numDimensions) {
            String msg = "Arrays must have same dimensions to add. found this.numDimensions()=" + numDimensions + " v.numDimensions()=" + v.numDimensions();
            throw new IllegalArgumentException(msg);
        }
        double[] result = new double[numDimensions];
        for (int i = 0; i < numDimensions; ++i) {
            result[i] = this.value(i) + v.value(i);
        }
        return new DenseVector(result);
    }

    @Override
    public double dotProduct(Vector v) {
        this.verifyMatchingDimensions(v);
        double product = 0.0;
        int i = this.numDimensions();
        while (--i >= 0) {
            product += this.value(i) * v.value(i);
        }
        return product;
    }

    @Override
    public double cosine(Vector v) {
        this.verifyMatchingDimensions(v);
        double product = 0.0;
        double length1 = 0.0;
        double length2 = 0.0;
        int i = this.numDimensions();
        while (--i >= 0) {
            double val1 = this.value(i);
            double val2 = v.value(i);
            product += val1 * val2;
            length1 += val1 * val1;
            length2 += val2 * val2;
        }
        double cosine = product / Math.sqrt(length1 * length2);
        return cosine < -1.0 ? -1.0 : (cosine > 1.0 ? 1.0 : cosine);
    }

    @Override
    public boolean equals(Object that) {
        if (!(that instanceof Vector)) {
            return false;
        }
        Vector thatVector = (Vector)that;
        if (this.numDimensions() != thatVector.numDimensions()) {
            return false;
        }
        int i = this.numDimensions();
        while (--i >= 0) {
            if (this.value(i) == thatVector.value(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int code = 1;
        int numDimensions = this.numDimensions();
        for (int i = 0; i < numDimensions; ++i) {
            if (this.value(i) == 0.0) continue;
            long v = Double.doubleToLongBits(this.value(i));
            int valHash = (int)(v ^ v >>> 32);
            code = 31 * code + valHash;
        }
        return code;
    }

    void verifyMatchingDimensions(Vector v) {
        if (this.numDimensions() != v.numDimensions()) {
            String msg = "Vectors must be same dimensionality. This vector's dimensionality=" + this.numDimensions() + " Specified vector's dimensionality=" + v.numDimensions();
            throw new IllegalArgumentException(msg);
        }
    }
}

