/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.matrix;

import com.aliasi.matrix.AbstractMatrix;

public class ProximityMatrix
extends AbstractMatrix {
    private final double[][] mValues;
    private final int mSize;

    ProximityMatrix(double[][] values, boolean ignoreMe) {
        this.mValues = values;
        this.mSize = values.length;
    }

    public ProximityMatrix(int numDimensions) {
        this(ProximityMatrix.zeroValues(numDimensions), true);
    }

    @Override
    public int numColumns() {
        return this.mSize;
    }

    @Override
    public int numRows() {
        return this.mSize;
    }

    @Override
    public void setValue(int row, int column, double value) {
        if (row == column) {
            if (value == 0.0) {
                return;
            }
            String msg = "Cannot set non-zero diagonal on a proximity matrix. Found row=" + row + " column=" + column + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value < 0.0 || Double.isNaN(value)) {
            String msg = "Proximity matrix values must be >= 0.0 Found=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (row < column) {
            this.mValues[column - 1][row] = value;
        } else {
            this.mValues[row - 1][column] = value;
        }
    }

    @Override
    public double value(int row, int column) {
        if (row == column) {
            if (row > this.mSize) {
                String msg = "Index out of bounds row=column=" + row;
                throw new IndexOutOfBoundsException(msg);
            }
            return 0.0;
        }
        return row < column ? this.mValues[column - 1][row] : this.mValues[row - 1][column];
    }

    private static double[][] zeroValues(int numDimensions) {
        if (numDimensions < 1) {
            String msg = "Require positive number of dimensions. Found numDimensions=" + numDimensions;
            throw new IllegalArgumentException(msg);
        }
        double[][] values = new double[numDimensions - 1][];
        for (int i = 0; i < values.length; ++i) {
            values[i] = new double[i + 1];
            for (int j = 0; j < values[i].length; ++j) {
                values[i][j] = 0.0;
            }
        }
        return values;
    }
}

