/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.sentences;

import com.aliasi.sentences.HeuristicSentenceModel;
import com.aliasi.util.AbstractExternalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class MedlineSentenceModel
extends HeuristicSentenceModel
implements Serializable {
    static final long serialVersionUID = -8958290440993791272L;
    private static final Set<String> POSSIBLE_STOPS = new HashSet<String>();
    private static final Set<String> IMPOSSIBLE_PENULTIMATES;
    private static final Set<String> IMPOSSIBLE_SENTENCE_STARTS;
    private static final Set<String> LOWERCASE_STARTS;
    public static final MedlineSentenceModel INSTANCE;

    public MedlineSentenceModel() {
        super(POSSIBLE_STOPS, IMPOSSIBLE_PENULTIMATES, IMPOSSIBLE_SENTENCE_STARTS, true, true);
    }

    @Override
    protected boolean possibleStart(String[] tokens, String[] whitespaces, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (LOWERCASE_STARTS.contains(tokens[i])) {
                return true;
            }
            if (this.containsDigitOrUpper(tokens[i])) {
                return true;
            }
            if (whitespaces[i + 1].length() <= 0) continue;
            return false;
        }
        return false;
    }

    private boolean containsDigitOrUpper(CharSequence token) {
        int len = token.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isUpperCase(token.charAt(i))) {
                return true;
            }
            if (!Character.isDigit(token.charAt(i))) continue;
            return true;
        }
        return false;
    }

    Object writeReplace() {
        return new Serializer();
    }

    static {
        POSSIBLE_STOPS.add(".");
        POSSIBLE_STOPS.add("..");
        POSSIBLE_STOPS.add("!");
        POSSIBLE_STOPS.add("?");
        IMPOSSIBLE_PENULTIMATES = new HashSet<String>();
        IMPOSSIBLE_PENULTIMATES.add("Bros");
        IMPOSSIBLE_PENULTIMATES.add("No");
        IMPOSSIBLE_PENULTIMATES.add("al");
        IMPOSSIBLE_PENULTIMATES.add("vs");
        IMPOSSIBLE_PENULTIMATES.add("etc");
        IMPOSSIBLE_PENULTIMATES.add("Fig");
        IMPOSSIBLE_PENULTIMATES.add("Dr");
        IMPOSSIBLE_PENULTIMATES.add("Prof");
        IMPOSSIBLE_PENULTIMATES.add("PhD");
        IMPOSSIBLE_PENULTIMATES.add("MD");
        IMPOSSIBLE_PENULTIMATES.add("Co");
        IMPOSSIBLE_PENULTIMATES.add("Corp");
        IMPOSSIBLE_PENULTIMATES.add("Inc");
        IMPOSSIBLE_PENULTIMATES.add("Jan");
        IMPOSSIBLE_PENULTIMATES.add("Feb");
        IMPOSSIBLE_PENULTIMATES.add("Mar");
        IMPOSSIBLE_PENULTIMATES.add("Apr");
        IMPOSSIBLE_PENULTIMATES.add("Jul");
        IMPOSSIBLE_PENULTIMATES.add("Aug");
        IMPOSSIBLE_PENULTIMATES.add("Sep");
        IMPOSSIBLE_PENULTIMATES.add("Sept");
        IMPOSSIBLE_PENULTIMATES.add("Oct");
        IMPOSSIBLE_PENULTIMATES.add("Nov");
        IMPOSSIBLE_PENULTIMATES.add("Dec");
        IMPOSSIBLE_PENULTIMATES.add("St");
        IMPOSSIBLE_PENULTIMATES.add("AM");
        IMPOSSIBLE_PENULTIMATES.add("PM");
        IMPOSSIBLE_SENTENCE_STARTS = new HashSet<String>();
        IMPOSSIBLE_SENTENCE_STARTS.add(")");
        IMPOSSIBLE_SENTENCE_STARTS.add("]");
        IMPOSSIBLE_SENTENCE_STARTS.add("}");
        IMPOSSIBLE_SENTENCE_STARTS.add(">");
        IMPOSSIBLE_SENTENCE_STARTS.add("<");
        IMPOSSIBLE_SENTENCE_STARTS.add(".");
        IMPOSSIBLE_SENTENCE_STARTS.add("!");
        IMPOSSIBLE_SENTENCE_STARTS.add("?");
        IMPOSSIBLE_SENTENCE_STARTS.add(":");
        IMPOSSIBLE_SENTENCE_STARTS.add(";");
        IMPOSSIBLE_SENTENCE_STARTS.add("-");
        IMPOSSIBLE_SENTENCE_STARTS.add("--");
        IMPOSSIBLE_SENTENCE_STARTS.add("---");
        IMPOSSIBLE_SENTENCE_STARTS.add("%");
        LOWERCASE_STARTS = new HashSet<String>();
        LOWERCASE_STARTS.add("alpha");
        LOWERCASE_STARTS.add("beta");
        LOWERCASE_STARTS.add("gamma");
        LOWERCASE_STARTS.add("delta");
        LOWERCASE_STARTS.add("c");
        LOWERCASE_STARTS.add("i");
        LOWERCASE_STARTS.add("ii");
        LOWERCASE_STARTS.add("iii");
        LOWERCASE_STARTS.add("iv");
        LOWERCASE_STARTS.add("v");
        LOWERCASE_STARTS.add("vi");
        LOWERCASE_STARTS.add("vii");
        LOWERCASE_STARTS.add("viii");
        LOWERCASE_STARTS.add("ix");
        LOWERCASE_STARTS.add("x");
        INSTANCE = new MedlineSentenceModel();
    }

    static class Serializer
    extends AbstractExternalizable {
        static final long serialVersionUID = 8384392069391677984L;

        @Override
        public void writeExternal(ObjectOutput out) {
        }

        @Override
        public Object read(ObjectInput in) {
            return INSTANCE;
        }
    }
}

