/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.spell;

import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.Distance;
import com.aliasi.util.ObjectToCounterMap;
import com.aliasi.util.Proximity;
import com.aliasi.util.Strings;
import java.util.HashSet;
import java.util.Set;

public abstract class TokenizedDistance
implements Distance<CharSequence>,
Proximity<CharSequence> {
    final TokenizerFactory mTokenizerFactory;

    public TokenizedDistance(TokenizerFactory tokenizerFactory) {
        this.mTokenizerFactory = tokenizerFactory;
    }

    public TokenizerFactory tokenizerFactory() {
        return this.mTokenizerFactory;
    }

    public Set<String> tokenSet(CharSequence cSeq) {
        char[] cs = Strings.toCharArray(cSeq);
        return this.tokenSet(cs, 0, cs.length);
    }

    public Set<String> tokenSet(char[] cs, int start, int length) {
        String token;
        Tokenizer tokenizer = this.mTokenizerFactory.tokenizer(cs, start, length);
        HashSet<String> tokenSet = new HashSet<String>();
        while ((token = tokenizer.nextToken()) != null) {
            tokenSet.add(token);
        }
        return tokenSet;
    }

    public ObjectToCounterMap<String> termFrequencyVector(CharSequence cSeq) {
        String token;
        ObjectToCounterMap<String> termFrequency = new ObjectToCounterMap<String>();
        char[] cs = Strings.toCharArray(cSeq);
        Tokenizer tokenizer = this.mTokenizerFactory.tokenizer(cs, 0, cs.length);
        while ((token = tokenizer.nextToken()) != null) {
            termFrequency.increment(token);
        }
        return termFrequency;
    }
}

