/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tokenizer;

import com.aliasi.tokenizer.ModifiedTokenizerFactory;
import com.aliasi.tokenizer.ModifyTokenTokenizerFactory;
import com.aliasi.tokenizer.TokenizerFactory;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.regex.Pattern;

public class RegExFilteredTokenizerFactory
extends ModifyTokenTokenizerFactory
implements Serializable {
    static final long serialVersionUID = -288230238413152431L;
    private final Pattern mPattern;

    public RegExFilteredTokenizerFactory(TokenizerFactory factory, Pattern pattern) {
        super(factory);
        this.mPattern = pattern;
    }

    public Pattern getPattern() {
        return this.mPattern;
    }

    @Override
    public String modifyToken(String token) {
        return this.mPattern.matcher(token).matches() ? token : null;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "\n  pattern=" + this.mPattern + "\n  base factory=\n    " + this.baseTokenizerFactory().toString().replace("\n", "\n    ");
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    static class Serializer
    extends ModifiedTokenizerFactory.AbstractSerializer<RegExFilteredTokenizerFactory> {
        static final long serialVersionUID = -9179825153562519026L;

        public Serializer() {
            this(null);
        }

        public Serializer(RegExFilteredTokenizerFactory factory) {
            super(factory);
        }

        @Override
        public void writeExternalRest(ObjectOutput out) throws IOException {
            out.writeObject(((RegExFilteredTokenizerFactory)this.factory()).mPattern);
        }

        @Override
        public Object read(ObjectInput in, TokenizerFactory baseFactory) throws IOException, ClassNotFoundException {
            Pattern pattern = (Pattern)in.readObject();
            return new RegExFilteredTokenizerFactory(baseFactory, pattern);
        }
    }
}

