/*
 * Decompiled with CFR 0.152.
 */
package next.jdbc;

import clojure.lang.AFn;
import clojure.lang.AReference;
import clojure.lang.Compiler;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.LockingTransaction;
import clojure.lang.Namespace;
import clojure.lang.PersistentArrayMap;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Tuple;
import clojure.lang.Var;
import java.util.Arrays;
import java.util.concurrent.Callable;
import next.jdbc.connection$__GT_pool;
import next.jdbc.connection$as_properties;
import next.jdbc.connection$attempt_close;
import next.jdbc.connection$component;
import next.jdbc.connection$fn__12653;
import next.jdbc.connection$fn__12737;
import next.jdbc.connection$fn__12739;
import next.jdbc.connection$fn__12741;
import next.jdbc.connection$fn__12743;
import next.jdbc.connection$fn__12745;
import next.jdbc.connection$fn__12747;
import next.jdbc.connection$get_driver_connection;
import next.jdbc.connection$jdbc_url;
import next.jdbc.connection$loading__6789__auto____12651;
import next.jdbc.connection$make_connection;
import next.jdbc.connection$spec__GT_url_PLUS_etc;
import next.jdbc.connection$string__GT_url_PLUS_etc;
import next.jdbc.connection$url_PLUS_etc__GT_datasource;

public class connection__init {
    public static final Var const__0;
    public static final AFn const__1;
    public static final AFn const__3;
    public static final AFn const__4;
    public static final Var const__5;
    public static final Var const__6;
    public static final AFn const__12;
    public static final AFn const__56;
    public static final Var const__57;
    public static final AFn const__64;
    public static final Var const__65;
    public static final AFn const__68;
    public static final Var const__69;
    public static final AFn const__71;
    public static final Var const__72;
    public static final Var const__73;
    public static final AFn const__76;
    public static final Var const__77;
    public static final AFn const__80;
    public static final Var const__81;
    public static final AFn const__84;
    public static final Var const__85;
    public static final AFn const__88;
    public static final Var const__89;
    public static final AFn const__92;
    public static final Var const__93;
    public static final AFn const__96;
    public static final Var const__97;
    public static final AFn const__100;
    public static final Var const__101;
    public static final AFn const__104;
    public static final Var const__105;
    public static final Object const__106;
    public static final Var const__107;
    public static final Keyword const__108;
    public static final Object const__109;
    public static final Object const__110;
    public static final Var const__111;
    public static final Keyword const__112;
    public static final Object const__113;
    public static final Object const__114;

    public static void load() {
        Object v3;
        Object object = ((IFn)const__0.getRawRoot()).invoke((Object)const__1);
        IPersistentMap iPersistentMap = ((AReference)Namespace.find((Symbol)((Symbol)const__1))).resetMeta((IPersistentMap)const__3);
        Object object2 = ((IFn)new connection$loading__6789__auto____12651()).invoke();
        if (((Symbol)const__1).equals((Object)const__4)) {
            v3 = null;
        } else {
            LockingTransaction.runInTransaction((Callable)((Callable)((Object)new connection$fn__12653())));
            v3 = null;
        }
        Object object3 = const__5.set((Object)Boolean.TRUE);
        Var var = const__6;
        var.setMeta((IPersistentMap)const__12);
        Var var2 = var;
        var.bindRoot((Object)const__56);
        Var var3 = const__57;
        var3.setMeta((IPersistentMap)const__64);
        Var var4 = var3;
        var3.bindRoot((Object)new connection$as_properties());
        Var var5 = const__65;
        var5.setMeta((IPersistentMap)const__68);
        Var var6 = var5;
        var5.bindRoot((Object)new connection$get_driver_connection());
        Var var7 = const__69;
        var7.setMeta((IPersistentMap)const__71);
        Var var8 = var7;
        var7.bindRoot(((IFn)const__72.getRawRoot()).invoke((Object)PersistentArrayMap.EMPTY));
        Var var9 = const__73;
        var9.setMeta((IPersistentMap)const__76);
        Var var10 = var9;
        var9.bindRoot((Object)new connection$spec__GT_url_PLUS_etc());
        Var var11 = const__77;
        var11.setMeta((IPersistentMap)const__80);
        Var var12 = var11;
        var11.bindRoot((Object)new connection$jdbc_url());
        Var var13 = const__81;
        var13.setMeta((IPersistentMap)const__84);
        Var var14 = var13;
        var13.bindRoot((Object)new connection$__GT_pool());
        Var var15 = const__85;
        var15.setMeta((IPersistentMap)const__88);
        Var var16 = var15;
        var15.bindRoot((Object)new connection$attempt_close());
        Var var17 = const__89;
        var17.setMeta((IPersistentMap)const__92);
        Var var18 = var17;
        var17.bindRoot((Object)new connection$component());
        Object v23 = null;
        Var var19 = const__93;
        var19.setMeta((IPersistentMap)const__96);
        Var var20 = var19;
        var19.bindRoot((Object)new connection$string__GT_url_PLUS_etc());
        Var var21 = const__97;
        var21.setMeta((IPersistentMap)const__100);
        Var var22 = var21;
        var21.bindRoot((Object)new connection$url_PLUS_etc__GT_datasource());
        Var var23 = const__101;
        var23.setMeta((IPersistentMap)const__104);
        Var var24 = var23;
        var23.bindRoot((Object)new connection$make_connection());
        Object object4 = ((IFn)const__105.getRawRoot()).invoke(const__106, const__107.getRawRoot(), (Object)RT.mapUniqueKeys((Object[])new Object[]{const__108, new connection$fn__12737()}));
        Object object5 = ((IFn)const__105.getRawRoot()).invoke(const__109, const__107.getRawRoot(), (Object)RT.mapUniqueKeys((Object[])new Object[]{const__108, new connection$fn__12739()}));
        Object object6 = ((IFn)const__105.getRawRoot()).invoke(const__110, const__107.getRawRoot(), (Object)RT.mapUniqueKeys((Object[])new Object[]{const__108, new connection$fn__12741()}));
        Object object7 = ((IFn)const__105.getRawRoot()).invoke(const__109, const__111.getRawRoot(), (Object)RT.mapUniqueKeys((Object[])new Object[]{const__112, new connection$fn__12743()}));
        Object object8 = ((IFn)const__105.getRawRoot()).invoke(const__113, const__111.getRawRoot(), (Object)RT.mapUniqueKeys((Object[])new Object[]{const__112, new connection$fn__12745()}));
        Object object9 = ((IFn)const__105.getRawRoot()).invoke(const__114, const__111.getRawRoot(), (Object)RT.mapUniqueKeys((Object[])new Object[]{const__112, new connection$fn__12747()}));
    }

    public static void __init0() {
        const__0 = RT.var((String)"clojure.core", (String)"in-ns");
        const__1 = (AFn)((IObj)Symbol.intern(null, (String)"next.jdbc.connection")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"doc"), "Standard implementations of `get-datasource` and `get-connection`.\n\n  Also provides `dbtypes` as a map of all known database types, and\n  the `->pool` and `component` functions for creating pooled datasource\n  objects."}));
        const__3 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"doc"), "Standard implementations of `get-datasource` and `get-connection`.\n\n  Also provides `dbtypes` as a map of all known database types, and\n  the `->pool` and `component` functions for creating pooled datasource\n  objects."});
        const__4 = (AFn)Symbol.intern(null, (String)"clojure.core");
        const__5 = RT.var((String)"clojure.core", (String)"*warn-on-reflection*");
        const__6 = RT.var((String)"next.jdbc.connection", (String)"dbtypes");
        const__12 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"line"), 18, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "next/jdbc/connection.clj", RT.keyword(null, (String)"doc"), "A map of all known database types (including aliases) to the class name(s)\n  and port that `next.jdbc` supports out of the box. For databases that have\n  non-standard prefixes for the `:dbname` and/or `:host` values in the JDBC\n  string, this table includes `:dbname-separator` and/or `:host-prefix`. The\n  default prefix for `:dbname` is either `/` or `:` and for `:host` it is `//`.\n  For local databases, with no `:host`/`:port` segment in their JDBC URL, a\n  value of `:none` is provided for `:host` in this table.\n\n  For known database types, you can use `:dbtype` (and omit `:classname`).\n\n  If you want to use a database that is not in this list, you can specify\n  a new `:dbtype` along with the class name of the JDBC driver in `:classname`.\n  You will also need to specify `:port`. For example:\n\n     `{:dbtype \"acme\" :classname \"com.acme.JdbcDriver\" ...}`\n\n  The value of `:dbtype` should be the string that the driver is associated\n  with in the JDBC URL, i.e., the value that comes between the `jdbc:`\n  prefix and the `://<host>...` part. In the above example, the JDBC URL\n  that would be generated would be `jdbc:acme://<host>:<port>/<dbname>`.\n\n  If you want `next.jdbc` to omit the host/port part of the URL, specify\n  `:host :none`, which would produce a URL like: `jdbc:acme:<dbname>`,\n  which allows you to work with local databases (or drivers that do not\n  need host/port information).\n\n  The default prefix for the host name (or IP address) is `//`. You\n  can override this via the `:host-prefix` option.\n\n  The default separator between the host/port and the database name is `/`.\n  The default separator between the subprotocol and the database name,\n  for local databases with no host/port, is `:`. You can override this\n  via the `:dbname-separator` option.\n\n  JDBC drivers are not provided by `next.jdbc` -- you need to specify the\n  driver(s) you need as additional dependencies in your project. For\n  example:\n\n     `[com.acme/jdbc \"1.2.3\"] ; lein/boot`\n\n  or:\n\n     `com.acme/jdbc {:mvn/version \"1.2.3\"} ; CLI/deps.edn`\n\n  Note: the `:classname` value can be a string or a vector of strings. If\n  a vector of strings is provided, an attempt will be made to load each\n  named class in order, until one succeeds. This allows for a given `:dbtype`\n  to be used with different versions of a JDBC driver, if the class name\n  has changed over time (such as with MySQL)."});
        const__56 = (AFn)RT.map((Object[])new Object[]{"h2:mem", RT.map((Object[])new Object[]{RT.keyword(null, (String)"classname"), "org.h2.Driver"}), "mysql", RT.map((Object[])new Object[]{RT.keyword(null, (String)"classname"), Tuple.create((Object)"com.mysql.cj.jdbc.Driver", (Object)"com.mysql.jdbc.Driver"), RT.keyword(null, (String)"port"), 3306L}), "oracle:thin", RT.map((Object[])new Object[]{RT.keyword(null, (String)"classname"), "oracle.jdbc.OracleDriver", RT.keyword(null, (String)"host-prefix"), "@", RT.keyword(null, (String)"port"), 1521L}), "mssql", RT.map((Object[])new Object[]{RT.keyword(null, (String)"classname"), "com.microsoft.sqlserver.jdbc.SQLServerDriver", RT.keyword(null, (String)"alias-for"), "sqlserver", RT.keyword(null, (String)"dbname-separator"), ";DATABASENAME=", RT.keyword(null, (String)"port"), 1433L}), "pgsql", RT.map((Object[])new Object[]{RT.keyword(null, (String)"classname"), "com.impossibl.postgres.jdbc.PGDriver"}), "oracle", RT.map((Object[])new Object[]{RT.keyword(null, (String)"classname"), "oracle.jdbc.OracleDriver", RT.keyword(null, (String)"alias-for"), "oracle:thin", RT.keyword(null, (String)"host-prefix"), "@", RT.keyword(null, (String)"port"), 1521L}), "oracle:oci", RT.map((Object[])new Object[]{RT.keyword(null, (String)"classname"), "oracle.jdbc.OracleDriver", RT.keyword(null, (String)"host-prefix"), "@", RT.keyword(null, (String)"port"), 1521L}), "postgres", RT.map((Object[])new Object[]{RT.keyword(null, (String)"classname"), "org.postgresql.Driver", RT.keyword(null, (String)"alias-for"), "postgresql", RT.keyword(null, (String)"port"), 5432L}), "postgresql", RT.map((Object[])new Object[]{RT.keyword(null, (String)"classname"), "org.postgresql.Driver", RT.keyword(null, (String)"port"), 5432L}), "sqlite", RT.map((Object[])new Object[]{RT.keyword(null, (String)"classname"), "org.sqlite.JDBC", RT.keyword(null, (String)"host"), RT.keyword(null, (String)"none")}), "h2", RT.map((Object[])new Object[]{RT.keyword(null, (String)"classname"), "org.h2.Driver", RT.keyword(null, (String)"host"), RT.keyword(null, (String)"none")}), "jtds", RT.map((Object[])new Object[]{RT.keyword(null, (String)"classname"), "net.sourceforge.jtds.jdbc.Driver", RT.keyword(null, (String)"alias-for"), "jtds:sqlserver", RT.keyword(null, (String)"port"), 1433L}), "oracle:sid", RT.map((Object[])new Object[]{RT.keyword(null, (String)"classname"), "oracle.jdbc.OracleDriver", RT.keyword(null, (String)"alias-for"), "oracle:thin", RT.keyword(null, (String)"dbname-separator"), ":", RT.keyword(null, (String)"host-prefix"), "@", RT.keyword(null, (String)"port"), 1521L}), "mariadb", RT.map((Object[])new Object[]{RT.keyword(null, (String)"classname"), "org.mariadb.jdbc.Driver", RT.keyword(null, (String)"port"), 3306L}), "jtds:sqlserver", RT.map((Object[])new Object[]{RT.keyword(null, (String)"classname"), "net.sourceforge.jtds.jdbc.Driver", RT.keyword(null, (String)"port"), 1433L}), "hsqldb", RT.map((Object[])new Object[]{RT.keyword(null, (String)"classname"), "org.hsqldb.jdbcDriver", RT.keyword(null, (String)"host"), RT.keyword(null, (String)"none")}), "redshift", RT.map((Object[])new Object[]{RT.keyword(null, (String)"classname"), "com.amazon.redshift.jdbc.Driver"}), "timesten:client", RT.map((Object[])new Object[]{RT.keyword(null, (String)"classname"), "com.timesten.jdbc.TimesTenClientDriver", RT.keyword(null, (String)"dbname-separator"), ":dsn=", RT.keyword(null, (String)"host"), RT.keyword(null, (String)"none")}), "hsql", RT.map((Object[])new Object[]{RT.keyword(null, (String)"classname"), "org.hsqldb.jdbcDriver", RT.keyword(null, (String)"alias-for"), "hsqldb", RT.keyword(null, (String)"host"), RT.keyword(null, (String)"none")}), "derby", RT.map((Object[])new Object[]{RT.keyword(null, (String)"classname"), "org.apache.derby.jdbc.EmbeddedDriver", RT.keyword(null, (String)"host"), RT.keyword(null, (String)"none")}), "sqlserver", RT.map((Object[])new Object[]{RT.keyword(null, (String)"classname"), "com.microsoft.sqlserver.jdbc.SQLServerDriver", RT.keyword(null, (String)"dbname-separator"), ";DATABASENAME=", RT.keyword(null, (String)"port"), 1433L}), "duckdb", RT.map((Object[])new Object[]{RT.keyword(null, (String)"classname"), "org.duckdb.DuckDBDriver", RT.keyword(null, (String)"host"), RT.keyword(null, (String)"none")}), "timesten:direct", RT.map((Object[])new Object[]{RT.keyword(null, (String)"classname"), "com.timesten.jdbc.TimesTenDriver", RT.keyword(null, (String)"dbname-separator"), ":dsn=", RT.keyword(null, (String)"host"), RT.keyword(null, (String)"none")})});
        const__57 = RT.var((String)"next.jdbc.connection", (String)"as-properties");
        const__64 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), RT.classForName((String)"java.util.Properties"), RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"m")))), RT.keyword(null, (String)"doc"), "Convert any seq of pairs to a `java.util.Properties` instance.", RT.keyword(null, (String)"line"), 128, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "next/jdbc/connection.clj"});
        const__65 = RT.var((String)"next.jdbc.connection", (String)"get-driver-connection");
        const__68 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"url"), (Object)Symbol.intern(null, (String)"timeout"), (Object)Symbol.intern(null, (String)"etc")))), RT.keyword(null, (String)"doc"), "Common logic for loading the designated JDBC driver class and\n  obtaining the appropriate `Connection` object.", RT.keyword(null, (String)"line"), 136, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "next/jdbc/connection.clj"});
        const__69 = RT.var((String)"next.jdbc.connection", (String)"driver-cache");
        const__71 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"line"), 143, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "next/jdbc/connection.clj", RT.keyword(null, (String)"doc"), "An optimization for repeated calls to get-datasource, or for get-connection\n  called on a db-spec hash map, so that we only try to load the classes once."});
        const__72 = RT.var((String)"clojure.core", (String)"atom");
        const__73 = RT.var((String)"next.jdbc.connection", (String)"spec->url+etc");
        const__76 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)RT.map((Object[])new Object[]{RT.keyword(null, (String)"keys"), RT.vector((Object[])new Object[]{Symbol.intern(null, (String)"dbtype"), Symbol.intern(null, (String)"dbname"), Symbol.intern(null, (String)"host"), Symbol.intern(null, (String)"port"), Symbol.intern(null, (String)"classname"), Symbol.intern(null, (String)"dbname-separator"), Symbol.intern(null, (String)"host-prefix"), Symbol.intern(null, (String)"jdbcUrl")}), RT.keyword(null, (String)"as"), Symbol.intern(null, (String)"db-spec")})))), RT.keyword(null, (String)"doc"), "Given a database spec, return a JDBC URL and a map of any additional options.\n\n  As a special case, the database spec can contain jdbcUrl (just like ->pool),\n  in which case it will return that URL as-is and a map of any other options.", RT.keyword(null, (String)"line"), 148, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "next/jdbc/connection.clj"});
        const__77 = RT.var((String)"next.jdbc.connection", (String)"jdbc-url");
        const__80 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"db-spec")))), RT.keyword(null, (String)"doc"), "Given a database spec (as a hash map), return a JDBC URL with all the\n  attributes added to the query string. The result is suitable for use in\n  calls to `->pool` and `component` as the `:jdbcUrl` key in the parameter\n  map for the connection pooling library.\n\n  This allows you to build a connection-pooled datasource that needs\n  additional settings that the pooling library does not support, such as\n  `:serverTimezone`:\n\n```clojure\n  (def db-spec {:dbtype .. :dbname .. :user .. :password ..\n                :serverTimezone \"UTC\"})\n  (def ds (next.jdbc.connection/->pool\n           HikariCP {:jdbcUrl (next.jdbc.connection/jdbc-url db-spec)\n                     :maximumPoolSize 15}))\n```\n\n  This also clearly separates the attributes that should be part of the\n  JDBC URL from the attributes that should be configured on the pool.\n\n  Since JDBC drivers can handle URL encoding differently, if you are\n  trying to pass attributes that might need encoding, you should make\n  sure they are properly URL-encoded as values in the database spec hash map.\n  This function does **not** attempt to URL-encode values for you!", RT.keyword(null, (String)"line"), 213, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "next/jdbc/connection.clj"});
        const__81 = RT.var((String)"next.jdbc.connection", (String)"->pool");
        const__84 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"clazz"), (Object)Symbol.intern(null, (String)"db-spec")))), RT.keyword(null, (String)"doc"), "Given a (connection pooled datasource) class and a database spec, return a\n  connection pool object built from that class and the database spec.\n\n  Assumes the `clazz` has a `.setJdbcUrl` method (which HikariCP and c3p0 do).\n\n  If you already have a JDBC URL and want to use this method, pass `:jdbcUrl`\n  in the database spec (instead of `:dbtype`, `:dbname`, etc).\n\n  Properties for the connection pool object can be passed as mixed case\n  keywords that correspond to setter methods (just as `:jdbcUrl` maps to\n  `.setJdbcUrl`). `clojure.java.data/to-java` is used to construct the\n  object and call the setters.\n\n  Note that the result is not type-hinted (because there's no common base\n  class or interface that can be assumed). In particular, connection pooled\n  datasource objects may need to be closed but they don't necessarily implement\n  `java.io.Closeable` (HikariCP does, c3p0 does not).", RT.keyword(null, (String)"line"), 247, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "next/jdbc/connection.clj"});
        const__85 = RT.var((String)"next.jdbc.connection", (String)"attempt-close");
        const__88 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"obj")))), RT.keyword(null, (String)"doc"), "Given an arbitrary object that almost certainly supports a `.close`\n  method that takes no arguments and returns `void`, try to find it\n  and call it.", RT.keyword(null, (String)"line"), 271, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "next/jdbc/connection.clj"});
        const__89 = RT.var((String)"next.jdbc.connection", (String)"component");
        const__92 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"clazz"), (Object)Symbol.intern(null, (String)"db-spec")), Tuple.create((Object)Symbol.intern(null, (String)"clazz"), (Object)Symbol.intern(null, (String)"db-spec"), (Object)Symbol.intern(null, (String)"close-fn")))), RT.keyword(null, (String)"doc"), "Takes the same arguments as `->pool` but returns an entity compatible\n  with Stuart Sierra's Component: when `com.stuartsierra.component/start`\n  is called on it, it builds a connection pooled datasource, and returns\n  an entity that can either be invoked as a function with no arguments\n  to return that datasource, or can have `com.stuartsierra.component/stop`\n  called on it to shutdown the datasource (and return a new startable\n  entity).\n\n  By default, the datasource is shutdown by calling `.close` on it.\n  If the datasource class implements `java.io.Closeable` then a direct,\n  type-hinted call to `.close` will be used, with no reflection,\n  otherwise Java reflection will be used to find the first `.close`\n  method in the datasource class that takes no arguments and returns `void`.\n\n  If neither of those behaviors is appropriate, you may supply a third\n  argument to this function -- `close-fn` -- which performs whatever\n  action is appropriate to your chosen datasource class.", RT.keyword(null, (String)"line"), 287, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "next/jdbc/connection.clj"});
        const__93 = RT.var((String)"next.jdbc.connection", (String)"string->url+etc");
        const__96 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"s")))), RT.keyword(null, (String)"doc"), "Given a JDBC URL, return it with an empty set of options with no parsing.", RT.keyword(null, (String)"line"), 347, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "next/jdbc/connection.clj"});
        const__97 = RT.var((String)"next.jdbc.connection", (String)"url+etc->datasource");
    }

    public static void __init1() {
        const__100 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Tuple.create((Object)Symbol.intern(null, (String)"url"), (Object)Symbol.intern(null, (String)"etc"))))), RT.keyword(null, (String)"doc"), "Given a JDBC URL and a map of options, return a `DataSource` that can be\n  used to obtain a new database connection.", RT.keyword(null, (String)"line"), 352, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "next/jdbc/connection.clj"});
        const__101 = RT.var((String)"next.jdbc.connection", (String)"make-connection");
        const__104 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(((IObj)Tuple.create((Object)((IObj)Symbol.intern(null, (String)"datasource")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"DataSource")})), (Object)Symbol.intern(null, (String)"opts"))).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"java.sql.Connection")})))), RT.keyword(null, (String)"doc"), "Given a `DataSource` and a map of options, get a connection and update it\n  as specified by the options.\n\n  These options are supported:\n  * `:auto-commit` -- whether the connection should be set to auto-commit or not;\n      without this option, the default is `true` -- connections will auto-commit,\n  * `:read-only` -- whether the connection should be set to read-only mode,\n  * `:connection` -- a hash map of camelCase properties to set on the connection,\n      via reflection, e.g., :autoCommit, :readOnly, :schema...", RT.keyword(null, (String)"line"), 369, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "next/jdbc/connection.clj"});
        const__105 = RT.var((String)"clojure.core", (String)"extend");
        const__106 = RT.classForName((String)"clojure.lang.Associative");
        const__107 = RT.var((String)"next.jdbc.protocols", (String)"Sourceable");
        const__108 = RT.keyword(null, (String)"get-datasource");
        const__109 = RT.classForName((String)"javax.sql.DataSource");
        const__110 = RT.classForName((String)"java.lang.String");
        const__111 = RT.var((String)"next.jdbc.protocols", (String)"Connectable");
        const__112 = RT.keyword(null, (String)"get-connection");
        const__113 = RT.classForName((String)"java.sql.PreparedStatement");
        const__114 = RT.classForName((String)"java.lang.Object");
    }

    static {
        connection__init.__init0();
        connection__init.__init1();
        Compiler.pushNSandLoader((ClassLoader)RT.classForName((String)"next.jdbc.connection__init").getClassLoader());
        try {
            connection__init.load();
        }
        catch (Throwable throwable) {
            Var.popThreadBindings();
            throw throwable;
        }
        Var.popThreadBindings();
    }
}

