(ns aws.runtime
  (:require [lambda.util :as util]
            [lambda.runtime :as lambda-runtime]
            [aws.aws :as aws]
            [aws.ctx :as aws-ctx]
            [lambda.uuid :as uuid]
            [lambda.core :as lambda-core]
            [clojure.tools.logging :as log]))

(defn has-failed?
  [{:keys [error
           exception
           statusCode]
    :or {statusCode 200}}]
  (or error
      exception
      (> statusCode 399)))

#_(defn aws->send-response
    [ctx response]
    (log/info "Send response " response)
    (let [failed? (if (vector? response)
                    (-> (filter has-failed? response)
                        seq)
                    (has-failed? response))] ()
         (if failed?
           (aws/send-error ctx response)
           (aws/send-success ctx response))))

#_(defn loop-runtime
    [ctx handler & {:keys [filters next-request send-response]
                    :or   {filters     []
                           send-response aws->send-response}}]
    (util/log-startup)
    (binding [util/cache (atom {})]
      (let [ctx (-> ctx
                    (core/init-filters filters))]
        (loop [i 0
               next (next-request 0)]
          (let [{:keys [body] :as request} next
                invocation-id (-> request
                                  :invocation-id)]
            (when body
              (when (not= body :skip)
                (util/d-time
                 (str "Handling next request: [" i "], invocation-id: " invocation-id)
                 (lambda-runtime/impl->run-request
                  (-> ctx
                      (assoc :request request))
                  body
                  :handler handler
                  :filters filters
                  :send-response send-response
                  :invocation-id (-> request
                                     :invocation-id))))
              (recur (inc i)
                     (next-request (inc i)))))))))

(deftype AWSCustomRuntime [runtime-config]
  lambda-core/LambdaRuntime
  (init-runtime [_this ctx]
    (log/info "Initializing AWSCustomRuntime")
    (lambda-runtime/impl->init-runtime ctx runtime-config))
  (start-runtime [_this ctx]))

#_(defn lambda-custom-runtime
    [ctx handler & {:keys [filters]
                    :or   {filters     []}}]
    (loop-runtime (-> ctx
                      (aws-ctx/init))
                  handler
                  :filters filters
                  :next-request (fn [_i]
                                  (let [{:keys [error body] :as request} (aws/get-next-request)]
                                    (if-not error
                                      {:body body
                                       :invocation-id  (-> request
                                                           :headers
                                                           :lambda-runtime-aws-request-id
                                                           uuid/parse)}

                                      (do (log/error error)
                                          :skip))))))

(defn form-invocation-number
  [i]
  (format "00000000-0000-0000-0000-%012d" i))

#_(defn lambda-requests
    [ctx handler requests
     & {:keys [filters]
        :or   {filters     []}}]
    (util/log-startup)
    (let [requests (atom requests)]
      #_(loop-runtime (-> ctx
                          (aws-ctx/init))
                      handler
                      :filters filters
                      :next-request (fn [i]
                                      (let [next (first @requests)]
                                        (swap! requests rest)
                                        (if next
                                          {:body next
                                           :invocation-id (form-invocation-number i)}
                                          :skip))))))





