(ns edd.view-store.common)

(def default-store
  {:aggregate-store    []})

(def ^:dynamic *view-store* (atom default-store))

(defn get-store
  []
  *view-store*)

(defn get-type
  [ctx]
  (get-in ctx [:view-store :type]))

(defn validate-impl
  [impl supported]
  (when-not (map? supported)
    (throw (ex-info "Parameter error"
                    {:message  "Supported implementations need to be map. Usually containing :mock :main"
                     :provided supported})))
  (when-not (some #(= % impl) (keys supported))
    (throw (ex-info (str "Unknown implementation: '" impl "' " supported)
                    {:message   "Unknown view-store implementation"
                     :value     impl
                     :supported supported})))
  (when-not (get supported impl)
    (throw (ex-info (str "Unsupported implementation: '" impl "' " supported)
                    {:message   "Unknown view-store implementation"
                     :value     impl
                     :supported supported}))))

