(ns lambda.ctx
  (:require [malli.util :as mu]
            [lambda.util :as util]))

(def default-service-name :local-svc)

(defn init
  "Update name, overriding previous name"
  [{:keys [service-name]
    :or {service-name (keyword (util/get-env
                                "ServiceName"
                                default-service-name))}
    :as ctx}]
  (-> ctx
      (update :environment-name-lower
              #(or %
                   (util/get-env
                    "EnvironmentNameLower"
                    "local")))

      (assoc :service-name  service-name
             :hosted-zone-name (util/get-env
                                "PublicHostedZoneName"
                                "example.com"))))

(defn realm
  [ctx]
  (get-in ctx [:meta :realm]))

(defn get-service-name
  [ctx]
  (get ctx :service-name default-service-name))

(defn hosted-zone-name
  [ctx]
  (get ctx :hosted-zone-name))

(defn environment-name-lower
  [ctx]
  (get ctx :environment-name-lower))
