(ns aws.middleware.router
  (:require [lambda.core :as lambda-core]
            [edd.common :as edd-common]
            [lambda.util :as util]
            [sdk.aws.sqs :as sqs]
            [aws.ctx :as aws-ctx]))

(defn router->distribute-response
  [ctx {:keys [result] :as response}]
  (let [response-fields (select-keys response
                                     [:success
                                      :meta
                                      :result
                                      :error
                                      :exception
                                      :invocation-id
                                      :interaction-id
                                      :request-id])
        {:keys [error]} (sqs/sqs-publish
                         (assoc ctx

                                :queue
                                "glms-router-svc-response"

                                :message
                                (util/to-json
                                 {:Records [response-fields]})))]
    (when error
      (throw (ex-info "Distribution failed" error)))

    (cond
      result
      (update response :result
              #(edd-common/response->response-summary ctx %))

      :else
      response)))

(deftype EddAWSRouterMiddleware [config]
  lambda-core/LambdaMiddlware
  (init-middleware [_this ctx]
    (-> ctx
        aws-ctx/init))

  (do-process [_this ctx request  middleware-chain]
    (let [response (lambda-core/continue-process  middleware-chain ctx request)]
      (util/d-time
       "Execution EddAWSRouterMiddleware/do-process"
       (router->distribute-response ctx response)))))


