(ns lambda.test.fixture.core
  (:require [clojure.tools.logging :as log]
            [lambda.filters :as fl]
            [lambda.test.fixture.client :as client]
            [lambda.uuid :as uuid]
            [lambda.util :as util]))

(def next-url "http://mock/2018-06-01/runtime/invocation/next")

(def ^:dynamic *mocking* false)

(defn get-env-mock
  [base variable-name & [defaualt-value]]
  (let [sysenv (System/getenv)
        env (merge
             {"AWS_LAMBDA_RUNTIME_API" "mock"}
             base)
        value (get env variable-name
                   (get sysenv variable-name defaualt-value))]
    (log/info (format "Getting nock env variable: %s, has value: %s"
                      variable-name
                      value))
    value))

; TODO Update JWT tokens for this to work properl
(defn realm-mock
  [_ _ _] :test)

(defn number-to-uuid
  [n]
  (str
   "00000000-0000-0000-0000-"
   (format "%012d" n)))

(def created-date "20200426T061823Z")

(def inocation-id-0 (uuid/from-number 0))
(def inocation-id-1 (uuid/from-number 1))
(def inocation-id-2 (uuid/from-number 2))
(def inocation-id-3 (uuid/from-number 3))
(def inocation-id-4 (uuid/from-number 4))
(def inocation-id-5 (uuid/from-number 5))

(def response-endpoint-o (str "http://mock/2018-06-01/runtime/invocation/" inocation-id-0 "/response"))
(def response-endpoint-1 (str "http://mock/2018-06-01/runtime/invocation/" inocation-id-1 "/response"))

(def error-endpoint-o (str "http://mock/2018-06-01/runtime/invocation/" inocation-id-0 "/error"))

(def service-name :local-test)
(def ctx
  (-> {:service-name service-name}
      (assoc-in [:edd :config :secrets-file] "files/secret-eu-west.json")))

(defmacro mock-core
  "Usef for testing edd-core commands.
  Aliases: :requests :responses :traffic"
  [ctx & body]
  `(do
     (when lambda.test.fixture.core/*mocking*
       (throw (ex-info "Nested mocking" {:message "Nested mocking not allowed"})))
     (binding [lambda.test.fixture.core/*mocking* true]
       (let [ctx# ~ctx
             responses# (or (:traffic ctx#)
                            (:responses ctx#)
                            (:requests ctx#)
                            [])
             ctx# (update ctx#
                          :http-mock
                          #(merge {:ignore-missing true} %))]
         (with-redefs [lambda.filters/get-realm realm-mock
                       lambda.util/get-env (partial get-env-mock (:env ctx#))
                       sdk.aws.common/create-date (fn [] (get ctx#
                                                              :created-date
                                                              created-date))]
           (lambda.test.fixture.client/mock-http
            ctx#
            (or responses# [])
            (do
              ~@body)))))))
